/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.internal.collection;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.opennms.netmgt.config.api.collection.IColumn;
import org.opennms.netmgt.config.api.collection.IMibObject;
import org.opennms.netmgt.snmp.SnmpObjId;
import org.opennms.netmgt.snmp.SnmpObjIdXmlAdapter;

@XmlRootElement(name="column")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class ColumnImpl
implements IColumn {
    @XmlAttribute(name="oid")
    @XmlJavaTypeAdapter(value=SnmpObjIdXmlAdapter.class)
    private SnmpObjId m_oid;
    @XmlAttribute(name="alias")
    private String m_alias;
    @XmlAttribute(name="type")
    private String m_type;
    @XmlAttribute(name="display-hint")
    private String m_displayHint;

    public ColumnImpl() {
    }

    public ColumnImpl(String oid, String alias, String type) {
        this.m_oid = SnmpObjId.get((String)oid);
        this.m_alias = alias;
        this.m_type = type;
    }

    public ColumnImpl(String oid, String alias, String type, String displayHint) {
        this.m_oid = SnmpObjId.get((String)oid);
        this.m_alias = alias;
        this.m_type = type;
        this.m_displayHint = displayHint;
    }

    public ColumnImpl(IMibObject mibObject) {
        this.m_oid = mibObject.getOid();
        this.m_alias = mibObject.getAlias();
        this.m_type = mibObject.getType();
    }

    @Override
    public SnmpObjId getOid() {
        return this.m_oid;
    }

    public void setOid(SnmpObjId oid) {
        this.m_oid = oid;
    }

    public void setOid(String oid) {
        this.m_oid = SnmpObjId.get((String)oid);
    }

    @Override
    public String getAlias() {
        return this.m_alias;
    }

    public void setAlias(String alias) {
        this.m_alias = alias;
    }

    @Override
    public String getType() {
        return this.m_type;
    }

    public void setType(String type) {
        this.m_type = type;
    }

    @Override
    public String getDisplayHint() {
        return this.m_displayHint;
    }

    public void setDisplayHint(String displayHint) {
        this.m_displayHint = displayHint;
    }

    public static ColumnImpl asColumn(IColumn column) {
        if (column == null) {
            return null;
        }
        if (column instanceof ColumnImpl) {
            return (ColumnImpl)column;
        }
        ColumnImpl newColumn = new ColumnImpl();
        newColumn.setOid(column.getOid());
        newColumn.setAlias(column.getAlias());
        newColumn.setType(column.getType());
        newColumn.setDisplayHint(column.getDisplayHint());
        return newColumn;
    }

    public static ColumnImpl[] asColumns(IColumn[] columns) {
        if (columns == null) {
            return null;
        }
        ColumnImpl[] newColumns = new ColumnImpl[columns.length];
        for (int i = 0; i < columns.length; ++i) {
            newColumns[i] = ColumnImpl.asColumn(columns[i]);
        }
        return newColumns;
    }

    public String toString() {
        return "ColumnImpl [oid=" + String.valueOf(this.m_oid) + ", alias=" + this.m_alias + ", type=" + this.m_type + ", displayHint=" + this.m_displayHint + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.m_alias == null ? 0 : this.m_alias.hashCode());
        result = 31 * result + (this.m_displayHint == null ? 0 : this.m_displayHint.hashCode());
        result = 31 * result + (this.m_oid == null ? 0 : this.m_oid.hashCode());
        result = 31 * result + (this.m_type == null ? 0 : this.m_type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ColumnImpl)) {
            return false;
        }
        ColumnImpl other = (ColumnImpl)obj;
        if (this.m_alias == null ? other.m_alias != null : !this.m_alias.equals(other.m_alias)) {
            return false;
        }
        if (this.m_displayHint == null ? other.m_displayHint != null : !this.m_displayHint.equals(other.m_displayHint)) {
            return false;
        }
        if (this.m_oid == null ? other.m_oid != null : !this.m_oid.equals((Object)other.m_oid)) {
            return false;
        }
        return !(this.m_type == null ? other.m_type != null : !this.m_type.equals(other.m_type));
    }
}

