/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.persist.policies;

import com.google.common.base.Strings;
import java.util.Map;
import org.opennms.netmgt.model.OnmsIpInterface;
import org.opennms.netmgt.model.OnmsMetaData;
import org.opennms.netmgt.provision.BasePolicy;
import org.opennms.netmgt.provision.IpInterfacePolicy;
import org.opennms.netmgt.provision.annotations.Policy;
import org.opennms.netmgt.provision.annotations.Require;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
@Policy(value="Set Interface Metadata")
public class InterfaceMetadataSettingPolicy
extends BasePolicy<OnmsIpInterface>
implements IpInterfacePolicy {
    private String metadataContext = "requisition";
    private String metadataKey;
    private String metadataValue = "";

    public OnmsIpInterface act(OnmsIpInterface iface, Map<String, Object> attributes) {
        if (Strings.isNullOrEmpty((String)this.metadataKey) || Strings.isNullOrEmpty((String)this.metadataContext)) {
            return iface;
        }
        iface.addRequisionedMetaData(new OnmsMetaData(this.metadataContext, this.metadataKey, this.metadataValue != null ? this.metadataValue : ""));
        return iface;
    }

    public void setMetadataKey(String metadataKey) {
        this.metadataKey = metadataKey;
    }

    @Require(value={})
    public String getMetadataKey() {
        return this.metadataKey;
    }

    public void setMetadataValue(String metadataValue) {
        this.metadataValue = metadataValue;
    }

    @Require(value={})
    public String getMetadataValue() {
        return this.metadataValue;
    }

    public void setMetadataContext(String metadataContext) {
        this.metadataContext = metadataContext;
    }

    public String getMetadataContext() {
        return this.metadataContext;
    }

    public void setIpAddress(String ipAddress) {
        this.putCriteria("ipAddress", ipAddress);
    }

    public String getIpAddress() {
        return this.getCriteria("ipAddress");
    }

    public void setHostName(String hostName) {
        this.putCriteria("ipHostName", hostName);
    }

    public String getHostName() {
        return this.getCriteria("ipHostName");
    }
}

