/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.collection.api;

import org.opennms.netmgt.collection.api.AttributeType;
import org.opennms.netmgt.collection.api.CollectionAttribute;
import org.opennms.netmgt.collection.api.CollectionResource;
import org.opennms.netmgt.collection.api.CollectionSetVisitor;
import org.opennms.netmgt.collection.api.LatencyCollectionAttributeType;
import org.opennms.netmgt.collection.api.LatencyCollectionResource;
import org.opennms.netmgt.collection.api.Persister;
import org.opennms.netmgt.collection.api.ServiceParameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LatencyCollectionAttribute
implements CollectionAttribute {
    private static final Logger LOG = LoggerFactory.getLogger(LatencyCollectionAttribute.class);
    private LatencyCollectionResource m_resource;
    private LatencyCollectionAttributeType m_type;
    private Double m_value;
    private String m_name;

    public LatencyCollectionAttribute(LatencyCollectionResource resource, LatencyCollectionAttributeType type, String name, Double value) {
        this.m_resource = resource;
        this.m_type = type;
        this.m_name = name;
        this.m_value = value;
    }

    @Override
    public LatencyCollectionAttributeType getAttributeType() {
        return this.m_type;
    }

    @Override
    public String getName() {
        return this.m_name;
    }

    @Override
    public Double getNumericValue() {
        return this.m_value;
    }

    @Override
    public CollectionResource getResource() {
        return this.m_resource;
    }

    @Override
    public String getStringValue() {
        return null;
    }

    @Override
    public AttributeType getType() {
        return AttributeType.GAUGE;
    }

    @Override
    public boolean shouldPersist(ServiceParameters params) {
        return true;
    }

    @Override
    public void storeAttribute(Persister persister) {
        this.getAttributeType().storeAttribute(this, persister);
    }

    @Override
    public void visit(CollectionSetVisitor visitor) {
        LOG.debug("Visiting attribute {}", (Object)this);
        visitor.visitAttribute(this);
        visitor.completeAttribute(this);
    }

    @Override
    public String getMetricIdentifier() {
        return String.format("%s/%s", this.m_resource.getServiceName(), this.m_resource.getIpAddress());
    }

    public String toString() {
        return String.format("%s: %f", this.m_name, this.m_value);
    }
}

