/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.collection.adapters;

import javax.xml.bind.annotation.adapters.XmlAdapter;
import org.opennms.netmgt.collection.api.AttributeType;

public class AttributeTypeAdapter
extends XmlAdapter<String, AttributeType> {
    private final String supportedTypeNames;

    public AttributeTypeAdapter() {
        StringBuilder sb = new StringBuilder();
        sb.append("Supported types include: ");
        for (AttributeType knownType : AttributeType.values()) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(knownType.getName());
        }
        sb.append(".");
        this.supportedTypeNames = sb.toString();
    }

    public AttributeType unmarshal(String typeAsString) throws Exception {
        if (typeAsString == null) {
            throw new IllegalArgumentException("Type cannot be null.");
        }
        AttributeType type = AttributeType.parse(typeAsString);
        if (type == null) {
            throw new IllegalArgumentException(String.format("Unsupported attribute type '%s'. %s", typeAsString, this.supportedTypeNames));
        }
        return type;
    }

    public String marshal(AttributeType type) throws Exception {
        if (type == null) {
            throw new IllegalArgumentException("Type cannot be null.");
        }
        return type.getName();
    }
}

