/*
 * Decompiled with CFR 0.152.
 */
package com.novell.ldap;

import com.novell.ldap.DSMLSearchResults;
import com.novell.ldap.LDAPAddRequest;
import com.novell.ldap.LDAPConnection;
import com.novell.ldap.LDAPConstraints;
import com.novell.ldap.LDAPControl;
import com.novell.ldap.LDAPDeleteRequest;
import com.novell.ldap.LDAPEntry;
import com.novell.ldap.LDAPException;
import com.novell.ldap.LDAPLocalException;
import com.novell.ldap.LDAPMessage;
import com.novell.ldap.LDAPMessageQueue;
import com.novell.ldap.LDAPModification;
import com.novell.ldap.LDAPModifyDNRequest;
import com.novell.ldap.LDAPModifyRequest;
import com.novell.ldap.LDAPResponseQueue;
import com.novell.ldap.LDAPSearchConstraints;
import com.novell.ldap.LDAPSearchQueue;
import com.novell.ldap.LDAPSearchRequest;
import com.novell.ldap.LDAPSearchResults;
import com.novell.ldap.LDAPSocketFactory;
import com.novell.ldap.util.DSMLReader;
import com.novell.ldap.util.DSMLWriter;
import com.novell.ldap.util.HttpRequestCallback;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringBufferInputStream;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Map;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;

public class DsmlConnection
extends LDAPConnection {
    HttpClient con = new HttpClient();
    String serverString;
    String binddn;
    String pass;
    boolean isBound;
    boolean isConnected;
    boolean useSoap;
    private String host;
    HttpRequestCallback callback;

    private LDAPMessage sendMessage(LDAPMessage lDAPMessage) throws LDAPException {
        return (LDAPMessage)this.sendMessage(lDAPMessage, false);
    }

    private DSMLSearchResults execQuery(LDAPMessage lDAPMessage) throws LDAPException {
        return (DSMLSearchResults)this.sendMessage(lDAPMessage, true);
    }

    private Object sendMessage(LDAPMessage lDAPMessage, boolean bl) throws LDAPException {
        try {
            PostMethod postMethod = new PostMethod(this.serverString);
            postMethod.setRequestHeader("Content-Type", "text/xml; charset=utf8");
            if (this.useSoap) {
                postMethod.setRequestHeader("SOAPAction", "#batchRequest");
            }
            if (this.callback != null) {
                this.callback.manipulationPost(postMethod, this);
            }
            StringWriter stringWriter = new StringWriter();
            DSMLWriter dSMLWriter = new DSMLWriter(stringWriter);
            PrintWriter printWriter = new PrintWriter(stringWriter);
            printWriter.println("<?xml version=\"1.0\" encoding=\"UTF8\"?>");
            if (this.useSoap) {
                printWriter.println("<soap-env:Envelope xmlns:soap-env=\"http://schemas.xmlsoap.org/soap/envelope/\">");
                printWriter.println("<soap-env:Body>");
            }
            dSMLWriter.writeMessage(lDAPMessage);
            dSMLWriter.finish();
            if (this.useSoap) {
                printWriter.println("</soap-env:Body>");
                printWriter.println("</soap-env:Envelope>");
            }
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(stringWriter.toString().getBytes("UTF-8"));
            postMethod.setRequestBody((InputStream)byteArrayInputStream);
            this.con.executeMethod((HttpMethod)postMethod);
            if (postMethod.getStatusCode() != 200) {
                if (postMethod.getStatusCode() == 401 || postMethod.getStatusCode() == 403) {
                    throw new LDAPException(LDAPException.resultCodeToString(49), 49, LDAPException.resultCodeToString(49));
                }
                throw new LDAPException(LDAPException.resultCodeToString(52), 52, postMethod.getStatusText());
            }
            DSMLReader dSMLReader = new DSMLReader(postMethod.getResponseBodyAsStream());
            postMethod.releaseConnection();
            ArrayList arrayList = dSMLReader.getErrors();
            if (arrayList.size() > 0) {
                throw (LDAPException)arrayList.get(0);
            }
            if (bl) {
                return new DSMLSearchResults(dSMLReader);
            }
            return dSMLReader.readMessage();
        }
        catch (HttpException httpException) {
            throw new LDAPLocalException("Http Error", 91, httpException);
        }
        catch (IOException iOException) {
            throw new LDAPLocalException("Communications Error", 91, iOException);
        }
    }

    public ArrayList sendDoc(String string) throws LDAPException {
        ArrayList<LDAPMessage> arrayList = new ArrayList<LDAPMessage>();
        try {
            LDAPMessage lDAPMessage;
            PostMethod postMethod = new PostMethod(this.serverString);
            postMethod.setRequestHeader("Content-Type", "text/xml; charset=utf8");
            if (this.useSoap) {
                postMethod.setRequestHeader("SOAPAction", "#batchRequest");
            }
            if (this.callback != null) {
                this.callback.manipulationPost(postMethod, this);
            }
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            printWriter.println("<?xml version=\"1.0\" encoding=\"UTF8\"?>");
            if (this.useSoap) {
                printWriter.println("<soap-env:Envelope xmlns:soap-env=\"http://schemas.xmlsoap.org/soap/envelope/\">");
                printWriter.println("<soap-env:Body>");
            }
            printWriter.write(string);
            if (this.useSoap) {
                printWriter.println("</soap-env:Body>");
                printWriter.println("</soap-env:Envelope>");
            }
            StringBufferInputStream stringBufferInputStream = new StringBufferInputStream(stringWriter.toString());
            postMethod.setRequestBody((InputStream)stringBufferInputStream);
            this.con.executeMethod((HttpMethod)postMethod);
            DSMLReader dSMLReader = new DSMLReader(postMethod.getResponseBodyAsStream());
            postMethod.releaseConnection();
            ArrayList arrayList2 = dSMLReader.getErrors();
            if (arrayList2.size() > 0) {
                throw (LDAPException)arrayList2.get(0);
            }
            while ((lDAPMessage = dSMLReader.readMessage()) != null) {
                arrayList.add(lDAPMessage);
            }
        }
        catch (HttpException httpException) {
            throw new LDAPLocalException("Http Error", 91, httpException);
        }
        catch (IOException iOException) {
            throw new LDAPLocalException("Communications Error", 91, iOException);
        }
        return arrayList;
    }

    public DsmlConnection() {
        this.con.getState().setAuthenticationPreemptive(true);
        this.useSoap = true;
    }

    public DsmlConnection(LDAPSocketFactory lDAPSocketFactory) {
        this();
    }

    public void connect(String string, int n) throws LDAPException {
        this.serverString = string;
        this.host = string.substring(string.indexOf("//") + 2, string.indexOf("/", string.indexOf("//") + 2));
        this.isConnected = true;
    }

    public void bind(int n, String string, byte[] byArray, LDAPConstraints lDAPConstraints) throws LDAPException {
        this.bind(string, new String(byArray));
    }

    public LDAPResponseQueue bind(int n, String string, byte[] byArray, LDAPResponseQueue lDAPResponseQueue, LDAPConstraints lDAPConstraints) throws LDAPException {
        return null;
    }

    public LDAPResponseQueue bind(int n, String string, byte[] byArray, LDAPResponseQueue lDAPResponseQueue) throws LDAPException {
        return null;
    }

    public void bind(int n, String string, byte[] byArray) throws LDAPException {
        this.bind(string, new String(byArray));
    }

    public void bind(int n, String string, String string2, LDAPConstraints lDAPConstraints) throws LDAPException {
        this.bind(string, new String(string2));
    }

    public void bind(int n, String string, String string2) throws LDAPException {
        this.bind(string, new String(string2));
    }

    public void bind(String string, String string2, LDAPConstraints lDAPConstraints) throws LDAPException {
        this.bind(string, new String(string2));
    }

    public void bind(String string, String string2, Map map, Object object, LDAPConstraints lDAPConstraints) throws LDAPException {
        this.bind(string, new String(string2));
    }

    public void bind(String string, String string2, Map map, Object object) throws LDAPException {
        this.bind(string, new String(string2));
    }

    public void bind(String string, String string2, String[] stringArray, Map map, Object object, LDAPConstraints lDAPConstraints) throws LDAPException {
        this.bind(string, new String(string2));
    }

    public void bind(String string, String string2, String[] stringArray, Map map, Object object) throws LDAPException {
        this.bind(string, new String(this.pass));
    }

    public void bind(String string, String string2) throws LDAPException {
        if (this.isBound) {
            GetMethod getMethod = new GetMethod(this.serverString + "?clearbind");
            try {
                this.con.executeMethod((HttpMethod)getMethod);
            }
            catch (HttpException httpException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.isBound = false;
        this.con.getState().setCredentials(null, null, (Credentials)new UsernamePasswordCredentials(string, string2));
        this.search("", 0, "(objectClass=*)", new String[]{"1.1"}, false);
        this.isBound = true;
    }

    public void add(LDAPEntry lDAPEntry, LDAPConstraints lDAPConstraints) throws LDAPException {
        LDAPControl[] lDAPControlArray = lDAPConstraints != null ? lDAPConstraints.getControls() : null;
        LDAPAddRequest lDAPAddRequest = new LDAPAddRequest(lDAPEntry, lDAPControlArray);
        this.sendMessage(lDAPAddRequest);
    }

    public LDAPResponseQueue add(LDAPEntry lDAPEntry, LDAPResponseQueue lDAPResponseQueue, LDAPConstraints lDAPConstraints) throws LDAPException {
        return null;
    }

    public LDAPResponseQueue add(LDAPEntry lDAPEntry, LDAPResponseQueue lDAPResponseQueue) throws LDAPException {
        return null;
    }

    public void add(LDAPEntry lDAPEntry) throws LDAPException {
        this.add(lDAPEntry, (LDAPConstraints)null);
    }

    public void modify(String string, LDAPModification lDAPModification, LDAPConstraints lDAPConstraints) throws LDAPException {
        this.modify(string, new LDAPModification[]{lDAPModification}, lDAPConstraints);
    }

    public LDAPResponseQueue modify(String string, LDAPModification lDAPModification, LDAPResponseQueue lDAPResponseQueue, LDAPConstraints lDAPConstraints) throws LDAPException {
        return null;
    }

    public LDAPResponseQueue modify(String string, LDAPModification lDAPModification, LDAPResponseQueue lDAPResponseQueue) throws LDAPException {
        return null;
    }

    public void modify(String string, LDAPModification lDAPModification) throws LDAPException {
        this.modify(string, new LDAPModification[]{lDAPModification}, (LDAPConstraints)null);
    }

    public void modify(String string, LDAPModification[] lDAPModificationArray, LDAPConstraints lDAPConstraints) throws LDAPException {
        LDAPControl[] lDAPControlArray = lDAPConstraints != null ? lDAPConstraints.getControls() : null;
        LDAPModifyRequest lDAPModifyRequest = new LDAPModifyRequest(string, lDAPModificationArray, lDAPControlArray);
        this.sendMessage(lDAPModifyRequest);
    }

    public LDAPResponseQueue modify(String string, LDAPModification[] lDAPModificationArray, LDAPResponseQueue lDAPResponseQueue, LDAPConstraints lDAPConstraints) throws LDAPException {
        return null;
    }

    public LDAPResponseQueue modify(String string, LDAPModification[] lDAPModificationArray, LDAPResponseQueue lDAPResponseQueue) throws LDAPException {
        return null;
    }

    public void modify(String string, LDAPModification[] lDAPModificationArray) throws LDAPException {
        this.modify(string, lDAPModificationArray, (LDAPConstraints)null);
    }

    public void rename(String string, String string2, boolean bl, LDAPConstraints lDAPConstraints) throws LDAPException {
        this.rename(string, string2, "", bl, lDAPConstraints);
    }

    public LDAPResponseQueue rename(String string, String string2, boolean bl, LDAPResponseQueue lDAPResponseQueue, LDAPConstraints lDAPConstraints) throws LDAPException {
        return null;
    }

    public LDAPResponseQueue rename(String string, String string2, boolean bl, LDAPResponseQueue lDAPResponseQueue) throws LDAPException {
        return null;
    }

    public void rename(String string, String string2, boolean bl) throws LDAPException {
        this.rename(string, string2, "", bl, (LDAPConstraints)null);
    }

    public void rename(String string, String string2, String string3, boolean bl, LDAPConstraints lDAPConstraints) throws LDAPException {
        LDAPControl[] lDAPControlArray = lDAPConstraints != null ? lDAPConstraints.getControls() : null;
        LDAPModifyDNRequest lDAPModifyDNRequest = new LDAPModifyDNRequest(string, string2, string3, bl, lDAPControlArray);
        this.sendMessage(lDAPModifyDNRequest);
    }

    public LDAPResponseQueue rename(String string, String string2, String string3, boolean bl, LDAPResponseQueue lDAPResponseQueue, LDAPConstraints lDAPConstraints) throws LDAPException {
        return null;
    }

    public LDAPResponseQueue rename(String string, String string2, String string3, boolean bl, LDAPResponseQueue lDAPResponseQueue) throws LDAPException {
        return null;
    }

    public void rename(String string, String string2, String string3, boolean bl) throws LDAPException {
        this.rename(string, string2, string3, bl, (LDAPConstraints)null);
    }

    public void delete(String string, LDAPConstraints lDAPConstraints) throws LDAPException {
        LDAPControl[] lDAPControlArray = lDAPConstraints != null ? lDAPConstraints.getControls() : null;
        LDAPDeleteRequest lDAPDeleteRequest = new LDAPDeleteRequest(string, lDAPControlArray);
        this.sendMessage(lDAPDeleteRequest);
    }

    public LDAPResponseQueue delete(String string, LDAPResponseQueue lDAPResponseQueue, LDAPConstraints lDAPConstraints) throws LDAPException {
        return null;
    }

    public LDAPResponseQueue delete(String string, LDAPResponseQueue lDAPResponseQueue) throws LDAPException {
        return null;
    }

    public void delete(String string) throws LDAPException {
        this.delete(string, (LDAPConstraints)null);
    }

    public LDAPSearchResults search(String string, int n, String string2, String[] stringArray, boolean bl, LDAPSearchConstraints lDAPSearchConstraints) throws LDAPException {
        LDAPControl[] lDAPControlArray = lDAPSearchConstraints != null ? lDAPSearchConstraints.getControls() : null;
        LDAPSearchRequest lDAPSearchRequest = new LDAPSearchRequest(string, n, string2, stringArray, 0, 0, 0, bl, lDAPControlArray);
        DSMLSearchResults dSMLSearchResults = this.execQuery(lDAPSearchRequest);
        if (dSMLSearchResults == null) {
            dSMLSearchResults = new DSMLSearchResults(null);
        }
        return dSMLSearchResults;
    }

    public LDAPSearchQueue search(String string, int n, String string2, String[] stringArray, boolean bl, LDAPSearchQueue lDAPSearchQueue, LDAPSearchConstraints lDAPSearchConstraints) throws LDAPException {
        return null;
    }

    public LDAPSearchQueue search(String string, int n, String string2, String[] stringArray, boolean bl, LDAPSearchQueue lDAPSearchQueue) throws LDAPException {
        return null;
    }

    public LDAPSearchResults search(String string, int n, String string2, String[] stringArray, boolean bl) throws LDAPException {
        return this.search(string, n, string2, stringArray, bl, (LDAPSearchConstraints)null);
    }

    public boolean isConnectionAlive() {
        GetMethod getMethod = new GetMethod(this.serverString + "?wsdl");
        try {
            this.con.executeMethod((HttpMethod)getMethod);
            return true;
        }
        catch (HttpException httpException) {
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public boolean isBound() {
        return this.isBound;
    }

    public boolean isConnected() {
        return this.isConnected;
    }

    public boolean isTLS() {
        return this.serverString.toLowerCase().startsWith("https");
    }

    public void disconnect() throws LDAPException {
        this.serverString = null;
        this.isConnected = false;
    }

    public void disconnect(LDAPConstraints lDAPConstraints) throws LDAPException {
        this.disconnect();
    }

    public LDAPMessageQueue sendRequest(LDAPMessage lDAPMessage, LDAPMessageQueue lDAPMessageQueue) throws LDAPException {
        this.sendMessage(lDAPMessage);
        return null;
    }

    public HttpRequestCallback getCallback() {
        return this.callback;
    }

    public void setCallback(HttpRequestCallback httpRequestCallback) {
        this.callback = httpRequestCallback;
    }

    public String getBinddn() {
        return this.binddn;
    }

    public HttpClient getCon() {
        return this.con;
    }

    public String getHost() {
        return this.host;
    }

    public String getPass() {
        return this.pass;
    }

    public String getServerString() {
        return this.serverString;
    }

    public boolean isUseSoap() {
        return this.useSoap;
    }

    public void setUseSoap(boolean bl) {
        this.useSoap = bl;
    }
}

