/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.snmp.commands;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import org.apache.karaf.shell.api.action.Action;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.opennms.netmgt.snmp.SnmpAgentConfig;
import org.opennms.netmgt.snmp.SnmpObjId;
import org.opennms.netmgt.snmp.commands.SnmpRequestCommand;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Command(scope="opennms", name="snmp-get", description="Request one or more fully-qualified MIB objects from the agent on the specified host and print the results.")
@Service
public class GetCommand
extends SnmpRequestCommand
implements Action {
    private static final Logger LOG = LoggerFactory.getLogger(GetCommand.class);

    @Override
    public Object execute() {
        SnmpAgentConfig agent;
        LOG.debug("snmp:get {} {} {}", new Object[]{this.m_location != null ? "-l " + this.m_location : "", this.m_host, this.m_oids});
        List snmpObjIds = this.m_oids.stream().map(SnmpObjId::get).collect(Collectors.toList());
        try {
            agent = this.snmpAgentConfigFactory.getAgentConfig(InetAddress.getByName(this.m_host), this.m_location);
        }
        catch (UnknownHostException uhe) {
            System.out.println(String.format("Unknown host '%s' at location '%s': %s", this.m_host, this.m_location, uhe.getMessage()));
            return null;
        }
        CompletableFuture future = this.locationAwareSnmpClient.get(agent, snmpObjIds).withDescription("snmp:get").withLocation(this.m_location).withSystemId(this.m_systemId).execute();
        while (true) {
            try {
                ((List)future.get(1L, TimeUnit.SECONDS)).stream().forEach(res -> {
                    if (res.isError()) {
                        System.out.println(String.format("ERROR: %s", res));
                    } else {
                        System.out.println(String.format("%s%n", res));
                    }
                });
            }
            catch (TimeoutException e) {
                System.out.print(".");
                continue;
            }
            catch (InterruptedException | ExecutionException e) {
                System.out.println(String.format("\n %s: %s", this.m_host, e.getMessage()));
            }
            break;
        }
        return null;
    }
}

