/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.enlinkd.service.api;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.opennms.netmgt.enlinkd.model.BridgeBridgeLink;
import org.opennms.netmgt.enlinkd.model.BridgeMacLink;
import org.opennms.netmgt.enlinkd.service.api.BridgePort;
import org.opennms.netmgt.enlinkd.service.api.Topology;
import org.opennms.netmgt.model.OnmsNode;

public class SharedSegment
implements Topology {
    private Integer m_designatedBridgeId;
    private final Set<String> m_macsOnSegment = new HashSet<String>();
    private final Set<BridgePort> m_portsOnSegment = new HashSet<BridgePort>();
    private Date m_createTime;
    private Date m_lastPollTime;

    public Date getCreateTime() {
        return this.m_createTime;
    }

    public void setCreateTime(Date createTime) {
        this.m_createTime = createTime;
    }

    public Date getLastPollTime() {
        return this.m_lastPollTime;
    }

    public void setLastPollTime(Date lastPollTime) {
        this.m_lastPollTime = lastPollTime;
    }

    public void setDesignatedBridge(Integer designatedBridge) {
        this.m_designatedBridgeId = designatedBridge;
    }

    public Integer getDesignatedBridge() {
        return this.m_designatedBridgeId;
    }

    public BridgePort getDesignatedPort() {
        if (this.m_designatedBridgeId == null) {
            return null;
        }
        return this.getBridgePort(this.m_designatedBridgeId);
    }

    public boolean isEmpty() {
        return this.m_portsOnSegment.isEmpty();
    }

    public Set<BridgePort> getBridgePortsOnSegment() {
        return this.m_portsOnSegment;
    }

    public boolean noMacsOnSegment() {
        return this.m_macsOnSegment.isEmpty();
    }

    public Set<Integer> getBridgeIdsOnSegment() {
        HashSet<Integer> nodes = new HashSet<Integer>();
        for (BridgePort link : this.m_portsOnSegment) {
            if (link == null || link.getNodeId() == null) continue;
            nodes.add(link.getNodeId());
        }
        return nodes;
    }

    public Set<String> getMacsOnSegment() {
        return this.m_macsOnSegment;
    }

    public boolean containsMac(String mac) {
        return this.m_macsOnSegment.contains(mac);
    }

    public BridgePort getBridgePort(Integer nodeid) {
        if (nodeid == null) {
            return null;
        }
        for (BridgePort port : this.m_portsOnSegment) {
            if (port.getNodeId().intValue() != nodeid.intValue()) continue;
            return port;
        }
        return null;
    }

    public List<BridgeMacLink> getBridgeMacLinks() {
        ArrayList<BridgeMacLink> links = new ArrayList<BridgeMacLink>();
        if (this.m_designatedBridgeId == null) {
            return links;
        }
        BridgePort bridgePort = this.getDesignatedPort();
        this.m_macsOnSegment.forEach(mac -> {
            BridgeMacLink maclink = new BridgeMacLink();
            OnmsNode node = new OnmsNode();
            node.setId(bridgePort.getNodeId());
            maclink.setNode(node);
            maclink.setBridgePort(bridgePort.getBridgePort());
            maclink.setBridgePortIfIndex(bridgePort.getBridgePortIfIndex());
            maclink.setMacAddress(mac);
            maclink.setVlan(bridgePort.getVlan());
            maclink.setLinkType(BridgeMacLink.BridgeMacLinkType.BRIDGE_LINK);
            links.add(maclink);
        });
        return links;
    }

    public List<BridgeBridgeLink> getBridgeBridgeLinks() {
        ArrayList<BridgeBridgeLink> links = new ArrayList<BridgeBridgeLink>();
        if (this.m_designatedBridgeId == null) {
            return links;
        }
        BridgePort designatedPort = this.getDesignatedPort();
        OnmsNode designatedNode = new OnmsNode();
        designatedNode.setId(designatedPort.getNodeId());
        for (BridgePort port : this.m_portsOnSegment) {
            if (port.equals(designatedPort)) continue;
            BridgeBridgeLink link = new BridgeBridgeLink();
            OnmsNode node = new OnmsNode();
            node.setId(port.getNodeId());
            link.setNode(node);
            link.setBridgePort(port.getBridgePort());
            link.setBridgePortIfIndex(port.getBridgePortIfIndex());
            link.setVlan(port.getVlan());
            link.setDesignatedNode(designatedNode);
            link.setDesignatedPort(this.getDesignatedPort().getBridgePort());
            link.setDesignatedPortIfIndex(designatedPort.getBridgePortIfIndex());
            link.setDesignatedVlan(designatedPort.getVlan());
            links.add(link);
        }
        return links;
    }

    public boolean containsPort(BridgePort port) {
        return this.m_portsOnSegment.contains(port);
    }

    @Override
    public String printTopology() {
        StringBuilder strbfr = new StringBuilder();
        strbfr.append("segment -> designated bridge:[");
        strbfr.append(this.getDesignatedBridge());
        strbfr.append("]\n");
        for (BridgePort blink : this.m_portsOnSegment) {
            strbfr.append("        -> port:");
            if (blink == null) {
                strbfr.append("[null]");
            } else {
                strbfr.append(blink.printTopology());
            }
            strbfr.append("\n");
        }
        strbfr.append("        -> macs:");
        strbfr.append(this.getMacsOnSegment());
        return strbfr.toString();
    }
}

