/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.shaded.jasper.org.jfree.chart.urls;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import org.jfree.util.ObjectUtilities;
import org.opennms.shaded.jasper.org.jfree.chart.urls.CategoryURLGenerator;
import org.opennms.shaded.jasper.org.jfree.chart.util.ParamChecks;
import org.opennms.shaded.jasper.org.jfree.data.category.CategoryDataset;

public class StandardCategoryURLGenerator
implements CategoryURLGenerator,
Cloneable,
Serializable {
    private static final long serialVersionUID = 2276668053074881909L;
    private String prefix = "index.html";
    private String seriesParameterName = "series";
    private String categoryParameterName = "category";

    public StandardCategoryURLGenerator() {
    }

    public StandardCategoryURLGenerator(String prefix) {
        ParamChecks.nullNotPermitted(prefix, "prefix");
        this.prefix = prefix;
    }

    public StandardCategoryURLGenerator(String prefix, String seriesParameterName, String categoryParameterName) {
        ParamChecks.nullNotPermitted(prefix, "prefix");
        ParamChecks.nullNotPermitted(seriesParameterName, "seriesParameterName");
        ParamChecks.nullNotPermitted(categoryParameterName, "categoryParameterName");
        this.prefix = prefix;
        this.seriesParameterName = seriesParameterName;
        this.categoryParameterName = categoryParameterName;
    }

    @Override
    public String generateURL(CategoryDataset dataset, int series, int category) {
        String url = this.prefix;
        Comparable seriesKey = dataset.getRowKey(series);
        Comparable categoryKey = dataset.getColumnKey(category);
        boolean firstParameter = !url.contains("?");
        url = url + (firstParameter ? "?" : "&amp;");
        try {
            url = url + this.seriesParameterName + "=" + URLEncoder.encode(seriesKey.toString(), "UTF-8");
            url = url + "&amp;" + this.categoryParameterName + "=" + URLEncoder.encode(categoryKey.toString(), "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
        return url;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof StandardCategoryURLGenerator)) {
            return false;
        }
        StandardCategoryURLGenerator that = (StandardCategoryURLGenerator)obj;
        if (!ObjectUtilities.equal((Object)this.prefix, (Object)that.prefix)) {
            return false;
        }
        if (!ObjectUtilities.equal((Object)this.seriesParameterName, (Object)that.seriesParameterName)) {
            return false;
        }
        return ObjectUtilities.equal((Object)this.categoryParameterName, (Object)that.categoryParameterName);
    }

    public int hashCode() {
        int result = this.prefix != null ? this.prefix.hashCode() : 0;
        result = 29 * result + (this.seriesParameterName != null ? this.seriesParameterName.hashCode() : 0);
        result = 29 * result + (this.categoryParameterName != null ? this.categoryParameterName.hashCode() : 0);
        return result;
    }
}

