/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.shaded.jasper.org.exolab.castor.xml.validators;

import org.opennms.shaded.jasper.org.exolab.castor.xml.ValidationContext;
import org.opennms.shaded.jasper.org.exolab.castor.xml.ValidationException;
import org.opennms.shaded.jasper.org.exolab.castor.xml.validators.StringValidator;
import org.opennms.shaded.jasper.org.exolab.castor.xml.validators.ValidationUtils;

public class NameValidator
extends StringValidator {
    public static final short NCNAME = 0;
    public static final short NMTOKEN = 1;
    public static final short CDATA = 2;
    private short _type = 0;

    public NameValidator() {
    }

    public NameValidator(short type) {
        this._type = type;
    }

    @Override
    public void setRequired(boolean required) {
    }

    @Override
    public void validate(String value, ValidationContext context) throws ValidationException {
        super.validate(value, context);
        switch (this._type) {
            case 2: {
                if (ValidationUtils.isCDATA(value)) break;
                String err = "Name '" + value + "' is not a valid CDATA.";
                throw new ValidationException(err);
            }
            case 1: {
                if (ValidationUtils.isNMToken(value)) break;
                String err = "Name '" + value + "' is not a valid NMToken.";
                throw new ValidationException(err);
            }
            case 3: {
                if (ValidationUtils.isQName(value)) break;
                String err = "Name '" + value + "' is not a valid QName.";
                throw new ValidationException(err);
            }
            default: {
                if (ValidationUtils.isNCName(value)) break;
                String err = "Name '" + value + "' is not a valid NCName.";
                throw new ValidationException(err);
            }
        }
    }

    @Override
    public void validate(Object object) throws ValidationException {
        this.validate(object, (ValidationContext)null);
    }

    @Override
    public void validate(Object object, ValidationContext context) throws ValidationException {
        if (object != null) {
            this.validate(object.toString(), context);
        } else {
            this.validate(null, context);
        }
    }
}

