/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.shaded.jasper.org.exolab.castor.mapping.handlers;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.opennms.shaded.jasper.org.exolab.castor.mapping.FieldHandler;
import org.opennms.shaded.jasper.org.exolab.castor.mapping.GeneralizedFieldHandler;

public class EnumFieldHandler
extends GeneralizedFieldHandler {
    private Class _enumType = null;
    private Method _createMethod = null;
    private FieldHandler _handler = null;

    public EnumFieldHandler(Class enumType, FieldHandler handler, Method createMethod) {
        if (enumType == null) {
            String err = "The argument 'enumType' must not be null.";
            throw new IllegalArgumentException(err);
        }
        if (handler == null) {
            String err = "The argument 'handler' must not be null.";
            throw new IllegalArgumentException(err);
        }
        if (createMethod == null) {
            String err = "The argument 'createMethod' must not be null.";
            throw new IllegalArgumentException(err);
        }
        this._handler = handler;
        this.setFieldHandler(handler);
        this._enumType = enumType;
        this._createMethod = createMethod;
        int mods = createMethod.getModifiers();
        if (!Modifier.isStatic(mods)) {
            String err = "The factory create method specified for " + enumType.getName() + " must be static";
            throw new IllegalArgumentException(err);
        }
    }

    @Override
    public Object convertUponGet(Object value) {
        return value;
    }

    @Override
    public Object convertUponSet(Object value) throws IllegalStateException {
        Object obj = null;
        if (value != null) {
            Object[] args = new String[]{value.toString()};
            try {
                obj = this._createMethod.invoke(null, args);
            }
            catch (InvocationTargetException ite) {
                Throwable toss = ite.getTargetException();
                throw new IllegalStateException(toss.toString());
            }
            catch (IllegalAccessException iae) {
                throw new IllegalStateException(iae.toString());
            }
        }
        return obj;
    }

    @Override
    public Class getFieldType() {
        return this._enumType;
    }

    @Override
    public Object newInstance(Object parent) throws IllegalStateException {
        return "";
    }

    @Override
    public Object newInstance(Object parent, Object[] args) throws IllegalStateException {
        return "";
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof FieldHandler)) {
            return false;
        }
        return this._handler.getClass().isInstance(obj) || this.getClass().isInstance(obj);
    }
}

