/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export;

import java.awt.font.GlyphVector;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextLayout;
import java.text.AttributedCharacterIterator;
import java.util.Locale;
import net.sf.jasperreports.engine.JRPrintText;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.export.AbstractPdfTextRenderer;
import net.sf.jasperreports.engine.export.AbstractTextRenderer;
import net.sf.jasperreports.engine.export.JRPdfExporter;
import net.sf.jasperreports.engine.export.JRPdfExporterTagHelper;
import net.sf.jasperreports.engine.export.PdfGlyphGraphics2D;
import net.sf.jasperreports.engine.util.JRStyledText;
import net.sf.jasperreports.export.pdf.PdfProducer;
import net.sf.jasperreports.export.pdf.classic.ClassicPdfProducer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.opennms.shaded.jasper.com.lowagie.text.pdf.PdfContentByte;
import org.opennms.shaded.jasper.com.lowagie.text.pdf.PdfDictionary;
import org.opennms.shaded.jasper.com.lowagie.text.pdf.PdfName;
import org.opennms.shaded.jasper.com.lowagie.text.pdf.PdfString;

public class PdfGlyphRenderer
extends AbstractPdfTextRenderer {
    private static final Log log = LogFactory.getLog(PdfGlyphRenderer.class);
    private static final boolean PATCHED_ITEXT = PdfGlyphRenderer.determinePatchedItext();
    private ClassicPdfProducer itextPdfProducer;
    private PdfContentByte pdfContentByte;
    private boolean addActualText;
    private PdfGlyphGraphics2D pdfGraphics2D;

    private static boolean determinePatchedItext() {
        try {
            PdfContentByte.class.getMethod("showText", GlyphVector.class);
            return true;
        }
        catch (NoSuchMethodException e) {
            log.warn((Object)"Unpatched iText found, cannot use glyph rendering");
            return false;
        }
        catch (SecurityException e) {
            throw new JRRuntimeException(e);
        }
    }

    public static boolean supported() {
        return PATCHED_ITEXT;
    }

    public PdfGlyphRenderer(JasperReportsContext jasperReportsContext, boolean ignoreMissingFont, boolean addActualText) {
        this(jasperReportsContext, ignoreMissingFont, true, false, addActualText);
    }

    public PdfGlyphRenderer(JasperReportsContext jasperReportsContext, boolean ignoreMissingFont, boolean defaultIndentFirstLine, boolean defaultJustifyLastLine, boolean addActualText) {
        super(jasperReportsContext, ignoreMissingFont, defaultIndentFirstLine, defaultJustifyLastLine);
        this.addActualText = addActualText;
    }

    @Override
    public void initialize(JRPdfExporter pdfExporter, PdfProducer pdfProducer, JRPdfExporterTagHelper tagHelper, JRPrintText text, JRStyledText styledText, int offsetX, int offsetY) {
        if (!(pdfProducer instanceof ClassicPdfProducer)) {
            throw new IllegalArgumentException("Only ClassicPdfProducer is supported");
        }
        super.initialize(pdfExporter, pdfProducer, tagHelper, text, styledText, offsetX, offsetY);
        this.itextPdfProducer = (ClassicPdfProducer)pdfProducer;
        this.pdfContentByte = this.itextPdfProducer.getPdfContentByte();
    }

    @Override
    public void render() {
        boolean addText;
        Locale locale = this.pdfExporter.getTextLocale(this.text);
        this.pdfGraphics2D = new PdfGlyphGraphics2D(this.pdfContentByte, this.pdfExporter, this.itextPdfProducer, locale);
        boolean bl = addText = this.addActualText && !this.itextPdfProducer.getContext().isTagged();
        if (addText) {
            PdfDictionary markedContentProps = new PdfDictionary();
            markedContentProps.put(PdfName.ACTUALTEXT, new PdfString(this.allText, "UnicodeBig"));
            this.pdfContentByte.beginMarkedContentSequence(PdfName.SPAN, markedContentProps, true);
        }
        super.render();
        if (addText) {
            this.pdfContentByte.endMarkedContentSequence();
        }
        this.pdfGraphics2D.dispose();
    }

    @Override
    public void draw() {
        if (this.bulletChunk != null) {
            AttributedCharacterIterator bulletIterator = this.bulletChunk.getIterator();
            LineBreakMeasurer lineMeasurer = new LineBreakMeasurer(bulletIterator, this.getFontRenderContext());
            TextLayout bulletLayout = lineMeasurer.nextLayout(1000.0f, bulletIterator.getEndIndex(), true);
            bulletLayout.draw(this.pdfGraphics2D, (float)this.x + this.drawPosX - bulletLayout.getVisibleAdvance() - 10.0f, (float)(this.y + this.topPadding) + this.verticalAlignOffset + this.drawPosY);
        }
        AbstractTextRenderer.TabSegment segment = (AbstractTextRenderer.TabSegment)this.segments.get(this.segmentIndex);
        segment.layout.draw(this.pdfGraphics2D, (float)this.x + this.drawPosX, (float)(this.y + this.topPadding) + this.verticalAlignOffset + this.drawPosY);
    }

    @Override
    public boolean addActualText() {
        return this.addActualText;
    }
}

