/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export;

import java.awt.Graphics2D;
import java.awt.font.FontRenderContext;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextLayout;
import java.text.AttributedCharacterIterator;
import net.sf.jasperreports.engine.JRPrintText;
import net.sf.jasperreports.engine.JRStyledTextAttributeSelector;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.export.AbstractTextRenderer;
import net.sf.jasperreports.engine.util.JRStyledText;
import net.sf.jasperreports.engine.util.JRStyledTextUtil;

public class AwtTextRenderer
extends AbstractTextRenderer {
    protected final JRStyledTextAttributeSelector noBackcolorSelector;
    protected final JRStyledTextUtil styledTextUtil;
    private Graphics2D grx;

    public AwtTextRenderer(JasperReportsContext jasperReportsContext, boolean isMinimizePrinterJobSize, boolean ignoreMissingFont) {
        this(jasperReportsContext, isMinimizePrinterJobSize, ignoreMissingFont, true, false);
    }

    public AwtTextRenderer(JasperReportsContext jasperReportsContext, boolean isMinimizePrinterJobSize, boolean ignoreMissingFont, boolean defaultIndentFirstLine, boolean defaultJustifyLastLine) {
        super(jasperReportsContext, isMinimizePrinterJobSize, ignoreMissingFont, defaultIndentFirstLine, defaultJustifyLastLine);
        this.noBackcolorSelector = JRStyledTextAttributeSelector.getNoBackcolorSelector(jasperReportsContext);
        this.styledTextUtil = JRStyledTextUtil.getInstance(jasperReportsContext);
    }

    public void initialize(Graphics2D grx, JRPrintText text, int offsetX, int offsetY) {
        JRStyledText styledText = this.styledTextUtil.getProcessedStyledText(text, this.noBackcolorSelector, null);
        if (styledText == null) {
            return;
        }
        this.grx = grx;
        super.initialize(text, styledText, offsetX, offsetY);
    }

    @Override
    public void draw() {
        if (this.bulletChunk != null) {
            AttributedCharacterIterator bulletIterator = this.bulletChunk.getIterator();
            LineBreakMeasurer lineMeasurer = new LineBreakMeasurer(bulletIterator, this.getFontRenderContext());
            TextLayout bulletLayout = lineMeasurer.nextLayout(1000.0f, bulletIterator.getEndIndex(), true);
            bulletLayout.draw(this.grx, (float)this.x + this.drawPosX - bulletLayout.getVisibleAdvance() - 10.0f, (float)(this.y + this.topPadding) + this.verticalAlignOffset + this.drawPosY);
        }
        AbstractTextRenderer.TabSegment segment = (AbstractTextRenderer.TabSegment)this.segments.get(this.segmentIndex);
        segment.layout.draw(this.grx, (float)this.x + this.drawPosX, (float)(this.y + this.topPadding) + this.verticalAlignOffset + this.drawPosY);
    }

    @Override
    public FontRenderContext getFontRenderContext() {
        return this.grx.getFontRenderContext();
    }
}

