/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.components.sort;

import java.util.Locale;
import java.util.TimeZone;
import net.sf.jasperreports.components.sort.AbstractFieldComparator;
import net.sf.jasperreports.components.sort.FieldBooleanComparator;
import net.sf.jasperreports.components.sort.FieldDateComparator;
import net.sf.jasperreports.components.sort.FieldNumberComparator;
import net.sf.jasperreports.components.sort.FieldTextComparator;
import net.sf.jasperreports.components.sort.FilterTypesEnum;

public class FieldComparatorFactory {
    private FieldComparatorFactory() {
    }

    public static AbstractFieldComparator<?> createFieldComparator(FilterTypesEnum filterTypeEnum, String filterPattern, Locale locale, TimeZone timeZone) {
        switch (filterTypeEnum) {
            case TIME: 
            case DATE: {
                return new FieldDateComparator(filterPattern, locale, timeZone);
            }
            case NUMERIC: {
                return new FieldNumberComparator(filterPattern, locale);
            }
            case TEXT: {
                return new FieldTextComparator(locale);
            }
            case BOOLEAN: {
                return new FieldBooleanComparator();
            }
        }
        return null;
    }
}

