/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.components.barcode4j;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import net.sf.jasperreports.components.barcode4j.Barcode4jComponent;
import net.sf.jasperreports.components.barcode4j.BarcodeImageProducer;
import net.sf.jasperreports.engine.JRComponentElement;
import net.sf.jasperreports.engine.JRPropertiesUtil;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.renderers.Renderable;
import net.sf.jasperreports.renderers.SimpleDataRenderer;
import org.krysalis.barcode4j.BarcodeGenerator;
import org.krysalis.barcode4j.output.CanvasProvider;
import org.krysalis.barcode4j.output.bitmap.BitmapCanvasProvider;

public class BarcodeRasterizedImageProducer
implements BarcodeImageProducer {
    public static final String PROPERTY_RESOLUTION = "net.sf.jasperreports.components.barcode4j.image.resolution";
    public static final String PROPERTY_GRAY = "net.sf.jasperreports.components.barcode4j.image.gray";
    public static final String PROPERTY_ANTIALIAS = "net.sf.jasperreports.components.barcode4j.image.antiAlias";

    @Override
    public Renderable createImage(JasperReportsContext jasperReportsContext, JRComponentElement componentElement, BarcodeGenerator barcode, String message) {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            int resolution = JRPropertiesUtil.getInstance(jasperReportsContext).getIntegerProperty(componentElement, PROPERTY_RESOLUTION, 300);
            boolean gray = JRPropertiesUtil.getInstance(jasperReportsContext).getBooleanProperty(componentElement, PROPERTY_GRAY, true);
            boolean antiAlias = JRPropertiesUtil.getInstance(jasperReportsContext).getBooleanProperty(componentElement, PROPERTY_ANTIALIAS, true);
            int imageType = gray ? 10 : 12;
            BitmapCanvasProvider provider = new BitmapCanvasProvider((OutputStream)out, "image/x-png", resolution, imageType, antiAlias, ((Barcode4jComponent)componentElement.getComponent()).getOrientationValue().getValue().intValue());
            barcode.generateBarcode((CanvasProvider)provider, message);
            provider.finish();
            byte[] imageData = out.toByteArray();
            return SimpleDataRenderer.getInstance(imageData);
        }
        catch (Exception e) {
            throw new JRRuntimeException(e);
        }
    }
}

