/*
 * Decompiled with CFR 0.152.
 */
package org.openid4java.util;

import com.google.inject.Inject;
import com.google.inject.Provider;
import javax.net.ssl.SSLContext;
import org.apache.http.conn.ssl.X509HostnameVerifier;
import org.openid4java.util.HttpCache;
import org.openid4java.util.HttpFetcher;
import org.openid4java.util.HttpRequestOptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpFetcherFactory {
    private final Provider<HttpFetcher> _provider;

    @Inject
    public HttpFetcherFactory(Provider<HttpFetcher> provider) {
        this._provider = provider;
    }

    public HttpFetcherFactory() {
        this(new HttpCacheProvider());
    }

    public HttpFetcherFactory(SSLContext sslContext) {
        this(new HttpCacheProvider(sslContext));
    }

    public HttpFetcherFactory(SSLContext sslContext, X509HostnameVerifier hostnameVerifier) {
        this(new HttpCacheProvider(sslContext, hostnameVerifier));
    }

    public HttpFetcher createFetcher(HttpRequestOptions defaultOptions) {
        HttpFetcher fetcher = (HttpFetcher)this._provider.get();
        fetcher.setDefaultRequestOptions(defaultOptions);
        return fetcher;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class HttpCacheProvider
    implements Provider<HttpFetcher> {
        private final SSLContext sslContext;
        private final X509HostnameVerifier hostnameVerifier;

        public HttpCacheProvider(SSLContext sslContext, X509HostnameVerifier hostnameVerifier) {
            this.sslContext = sslContext;
            this.hostnameVerifier = hostnameVerifier;
        }

        public HttpCacheProvider(SSLContext sslContext) {
            this(sslContext, null);
        }

        public HttpCacheProvider() {
            this(null, null);
        }

        public HttpFetcher get() {
            return new HttpCache(this.sslContext, this.hostnameVerifier);
        }
    }
}

