/*
 * Decompiled with CFR 0.152.
 */
package org.openid4java.discovery;

import java.io.Serializable;
import java.net.URL;
import java.util.HashSet;
import java.util.Set;
import org.openid4java.discovery.DiscoveryException;
import org.openid4java.discovery.Identifier;

public class DiscoveryInformation
implements Serializable {
    URL _opEndpoint;
    Identifier _claimedIdentifier;
    String _delegate;
    String _version;
    Set _types;
    public static final String OPENID10 = "http://openid.net/signon/1.0";
    public static final String OPENID11 = "http://openid.net/signon/1.1";
    public static final String OPENID2 = "http://specs.openid.net/auth/2.0/signon";
    public static final String OPENID2_OP = "http://specs.openid.net/auth/2.0/server";
    public static final String OPENID2_RP = "http://specs.openid.net/auth/2.0/return_to";
    public static final Set OPENID1_SIGNON_TYPES = new HashSet(){
        {
            this.add(DiscoveryInformation.OPENID10);
            this.add(DiscoveryInformation.OPENID11);
        }
    };
    public static final Set OPENID_SIGNON_TYPES = new HashSet(){
        {
            this.addAll(OPENID1_SIGNON_TYPES);
            this.add(DiscoveryInformation.OPENID2);
        }
    };
    public static final Set OPENID_OP_TYPES = new HashSet(){
        {
            this.addAll(OPENID_SIGNON_TYPES);
            this.add(DiscoveryInformation.OPENID2_OP);
        }
    };
    public static final Set OPENID_TYPES = new HashSet(){
        {
            this.addAll(OPENID_OP_TYPES);
            this.add(DiscoveryInformation.OPENID2_RP);
        }
    };

    public static boolean isOpenIDType(String type) {
        return OPENID_TYPES.contains(type);
    }

    public DiscoveryInformation(URL opEndpoint) throws DiscoveryException {
        this(opEndpoint, null, OPENID2_OP);
    }

    public DiscoveryInformation(URL opEndpoint, Identifier claimedIdentifier) throws DiscoveryException {
        this(opEndpoint, claimedIdentifier, OPENID2);
    }

    public DiscoveryInformation(URL opEndpoint, Identifier claimedIdentifier, String version) throws DiscoveryException {
        this(opEndpoint, claimedIdentifier, null, version);
    }

    public DiscoveryInformation(URL opEndpoint, Identifier claimedIdentifier, String delegate, String version) throws DiscoveryException {
        this(opEndpoint, claimedIdentifier, delegate, version, null);
    }

    public DiscoveryInformation(URL opEndpoint, Identifier claimedIdentifier, String delegate, String version, Set types) throws DiscoveryException {
        if (opEndpoint == null) {
            throw new DiscoveryException("Null OpenID Provider endpoint.");
        }
        this._opEndpoint = opEndpoint;
        this._claimedIdentifier = claimedIdentifier;
        this._delegate = delegate;
        this._version = version;
        this._types = types;
    }

    public boolean hasClaimedIdentifier() {
        return this._claimedIdentifier != null;
    }

    public boolean hasDelegateIdentifier() {
        return this._delegate != null;
    }

    public URL getOPEndpoint() {
        return this._opEndpoint;
    }

    public Identifier getClaimedIdentifier() {
        return this._claimedIdentifier;
    }

    public String getDelegateIdentifier() {
        return this._delegate;
    }

    public String getVersion() {
        return this._version;
    }

    public void setVersion(String version) {
        this._version = version;
    }

    public boolean isVersion2() {
        return OPENID2.equals(this._version) || OPENID2_OP.equals(this._version);
    }

    public Set getTypes() {
        return this._types;
    }

    public void setTypes(Set types) {
        this._types = types;
    }

    public boolean hasType(String type) {
        return this._types != null && this._types.contains(type);
    }

    public String toString() {
        return (this.isVersion2() ? "OpenID2" : "OpenID1") + "\nOP-endpoint:" + this._opEndpoint + "\nClaimedID:" + this._claimedIdentifier + "\nDelegate:" + this._delegate;
    }
}

