/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.protocols.xml.config;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.commons.lang.builder.CompareToBuilder;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.opennms.netmgt.collection.api.AttributeType;
import org.opennms.protocols.xml.config.XmlMapping;

@XmlRootElement(name="xml-object")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class XmlObject
implements Serializable,
Comparable<XmlObject>,
Cloneable {
    private static final long serialVersionUID = -774378322863486535L;
    @XmlAttribute(name="name", required=true)
    private String m_name;
    @XmlAttribute(name="type", required=true)
    private AttributeType m_dataType;
    @XmlAttribute(name="xpath", required=true)
    private String m_xpath;
    @XmlElement(name="xml-mapping")
    private List<XmlMapping> xmlMappings = new ArrayList<XmlMapping>();
    @XmlTransient
    private static final XmlMapping[] OF_XML_MAPPINGS = new XmlMapping[0];

    public XmlObject() {
    }

    public XmlObject(String name, AttributeType dataType) {
        this.m_name = name;
        this.m_dataType = dataType;
    }

    public XmlObject(XmlObject copy) {
        this.m_name = copy.m_name;
        this.m_dataType = copy.m_dataType;
        this.m_xpath = copy.m_xpath;
        copy.xmlMappings.stream().forEach(o -> this.xmlMappings.add(o.clone()));
    }

    public String getName() {
        return this.m_name;
    }

    public void setName(String name) {
        this.m_name = name;
    }

    public AttributeType getDataType() {
        return this.m_dataType;
    }

    public void setDataType(AttributeType dataType) {
        this.m_dataType = dataType;
    }

    public String getXpath() {
        return this.m_xpath;
    }

    public void setXpath(String xpath) {
        this.m_xpath = xpath;
    }

    @Override
    public int compareTo(XmlObject obj) {
        return new CompareToBuilder().append((Object)this.getName(), (Object)obj.getName()).append((Object)this.getDataType(), (Object)obj.getDataType()).append((Object)this.getXpath(), (Object)obj.getXpath()).append((Object[])this.getXmlMappings().toArray(OF_XML_MAPPINGS), (Object[])obj.getXmlMappings().toArray(OF_XML_MAPPINGS)).toComparison();
    }

    public boolean equals(Object obj) {
        if (obj instanceof XmlObject) {
            XmlObject other = (XmlObject)obj;
            return new EqualsBuilder().append((Object)this.getName(), (Object)other.getName()).append((Object)this.getDataType(), (Object)other.getDataType()).append((Object)this.getXpath(), (Object)other.getXpath()).append((Object[])this.getXmlMappings().toArray(OF_XML_MAPPINGS), (Object[])other.getXmlMappings().toArray(OF_XML_MAPPINGS)).isEquals();
        }
        return false;
    }

    public List<XmlMapping> getXmlMappings() {
        return this.xmlMappings;
    }

    public void setXmlMappings(List<XmlMapping> xmlMappings) {
        this.xmlMappings = xmlMappings;
    }

    public String map(String from) {
        String defaultMapping = from;
        if (this.xmlMappings != null) {
            for (XmlMapping xmlMapping : this.xmlMappings) {
                if (xmlMapping.getFrom() == null) {
                    defaultMapping = xmlMapping.getTo();
                    continue;
                }
                if (!xmlMapping.getFrom().equals(from)) continue;
                return xmlMapping.getTo();
            }
        }
        return defaultMapping;
    }

    public XmlObject clone() {
        return new XmlObject(this);
    }
}

