/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.protocols.xml.config;

import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.opennms.protocols.xml.config.Content;
import org.opennms.protocols.xml.config.Header;
import org.opennms.protocols.xml.config.Parameter;

@XmlRootElement(name="request")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class Request
implements Cloneable {
    @XmlAttribute
    private String method = "GET";
    @XmlElement(name="parameter")
    private List<Parameter> parameters = new ArrayList<Parameter>();
    @XmlElement(name="header")
    private List<Header> headers = new ArrayList<Header>();
    @XmlElement
    private Content content;

    public Request() {
    }

    public Request(Request copy) {
        this.method = copy.method;
        copy.parameters.stream().forEach(p -> this.parameters.add(p.clone()));
        copy.headers.stream().forEach(h -> this.headers.add(h.clone()));
        this.content = copy.content != null ? copy.content.clone() : null;
    }

    public String getMethod() {
        return this.method;
    }

    public List<Parameter> getParameters() {
        return this.parameters;
    }

    public String getParameter(String name) {
        for (Parameter p : this.parameters) {
            if (!p.getName().equals(name)) continue;
            return p.getValue();
        }
        return null;
    }

    public int getParameterAsInt(String name) {
        try {
            return Integer.parseInt(this.getParameter(name));
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    public boolean getParameterAsBoolean(String name) {
        return Boolean.valueOf(this.getParameter(name));
    }

    public List<Header> getHeaders() {
        return this.headers;
    }

    public String getHeader(String name) {
        for (Header h : this.headers) {
            if (!h.getName().equals(name)) continue;
            return h.getValue();
        }
        return null;
    }

    public Content getContent() {
        return this.content;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setParameters(List<Parameter> parameters) {
        this.parameters = parameters;
    }

    public void addParameter(String name, String value) {
        this.getParameters().add(new Parameter(name, value));
    }

    public void setHeaders(List<Header> headers) {
        this.headers = headers;
    }

    public void addHeader(String name, String value) {
        this.getHeaders().add(new Header(name, value));
    }

    public void setContent(Content content) {
        this.content = content;
    }

    public String toString() {
        return "Request [method=" + this.method + ", parameters=" + String.valueOf(this.parameters) + ", headers=" + String.valueOf(this.headers) + ", content=" + String.valueOf(this.content) + "]";
    }

    public Request clone() {
        return new Request(this);
    }
}

