/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.protocols.sftp;

import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SftpException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Properties;
import org.opennms.protocols.sftp.SftpUrlException;

public class SftpUrlConnection
extends URLConnection {
    public static final int DEFAULT_TIMEOUT = 30000;
    private Session m_session;
    private ChannelSftp m_channel;
    private boolean m_connected = false;

    protected SftpUrlConnection(URL url) {
        super(url);
    }

    @Override
    public void connect() throws IOException {
        if (this.m_connected) {
            return;
        }
        this.m_connected = true;
        if (this.url.getUserInfo() == null) {
            throw new IOException("User credentials required.");
        }
        JSch jsch = new JSch();
        try {
            String prvkey = System.getProperty("sftp.private-key.location");
            if (prvkey != null) {
                jsch.addIdentity(prvkey);
            }
            int port = this.url.getPort() > 0 ? this.url.getPort() : this.url.getDefaultPort();
            String[] userInfo = this.url.getUserInfo().split(":");
            this.m_session = jsch.getSession(userInfo[0], this.url.getHost(), port);
            if (userInfo.length > 1) {
                this.m_session.setPassword(userInfo[1]);
            }
            Properties config = new Properties();
            config.put("StrictHostKeyChecking", "no");
            this.m_session.setConfig(config);
            this.m_session.setTimeout(30000);
            this.m_session.connect();
            this.m_channel = (ChannelSftp)this.m_session.openChannel("sftp");
            this.m_channel.connect();
        }
        catch (JSchException e) {
            this.disconnect();
            throw new IOException("Can't connect using " + String.valueOf(this.url) + " because " + e.getMessage());
        }
    }

    public void disconnect() throws IOException {
        if (this.m_channel != null) {
            this.m_channel.disconnect();
        }
        if (this.m_session != null) {
            this.m_session.disconnect();
        }
    }

    public ChannelSftp getChannel() throws IOException {
        if (this.m_channel == null) {
            this.connect();
        }
        return this.m_channel;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        String filePath = this.getPath();
        try {
            return this.getChannel().get(filePath);
        }
        catch (SftpException e) {
            throw new IOException("Can't retrieve " + filePath + " from " + this.url.getHost() + " because " + e.getMessage());
        }
    }

    protected String getPath() throws SftpUrlException {
        return this.url.getPath();
    }
}

