/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config;

import java.io.IOException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.opennms.netmgt.config.EnhancedLinkdConfig;
import org.opennms.netmgt.config.enlinkd.EnlinkdConfiguration;

public abstract class EnhancedLinkdConfigManager
implements EnhancedLinkdConfig {
    private final ReadWriteLock m_globalLock = new ReentrantReadWriteLock();
    private final Lock m_readLock = this.m_globalLock.readLock();
    private final Lock m_writeLock = this.m_globalLock.writeLock();
    protected static EnlinkdConfiguration m_config;

    @Override
    public Lock getReadLock() {
        return this.m_readLock;
    }

    @Override
    public Lock getWriteLock() {
        return this.m_writeLock;
    }

    @Override
    public EnlinkdConfiguration getConfiguration() {
        this.getReadLock().lock();
        try {
            EnlinkdConfiguration enlinkdConfiguration = m_config;
            return enlinkdConfiguration;
        }
        finally {
            this.getReadLock().unlock();
        }
    }

    @Override
    public boolean useCdpDiscovery() {
        if (m_config.getUseCdpDiscovery() != null) {
            return m_config.getUseCdpDiscovery();
        }
        return true;
    }

    @Override
    public boolean useBridgeDiscovery() {
        if (m_config.getUseBridgeDiscovery() != null) {
            return m_config.getUseBridgeDiscovery();
        }
        return true;
    }

    @Override
    public boolean useLldpDiscovery() {
        if (m_config.getUseLldpDiscovery() != null) {
            return m_config.getUseLldpDiscovery();
        }
        return true;
    }

    @Override
    public boolean useOspfDiscovery() {
        if (m_config.getUseOspfDiscovery() != null) {
            return m_config.getUseOspfDiscovery();
        }
        return true;
    }

    @Override
    public boolean useIsisDiscovery() {
        if (m_config.getUseIsisDiscovery() != null) {
            return m_config.getUseIsisDiscovery();
        }
        return true;
    }

    @Override
    public boolean disableBridgeVlanDiscovery() {
        return Boolean.TRUE.equals(m_config.getDisableBridgeVlanDiscovery());
    }

    @Override
    public long getInitialSleepTime() {
        return m_config.getInitialSleepTime();
    }

    @Override
    public long getCdpRescanInterval() {
        return m_config.getCdpRescanInterval();
    }

    @Override
    public long getLldpRescanInterval() {
        return m_config.getLldpRescanInterval();
    }

    @Override
    public long getBridgeRescanInterval() {
        return m_config.getBridgeRescanInterval();
    }

    @Override
    public long getOspfRescanInterval() {
        return m_config.getOspfRescanInterval();
    }

    @Override
    public long getIsisRescanInterval() {
        return m_config.getIsisRescanInterval();
    }

    @Override
    public int getCdpPriority() {
        return m_config.getCdpPriority();
    }

    @Override
    public int getLldpPriority() {
        return m_config.getLldpPriority();
    }

    @Override
    public int getBridgePriority() {
        return m_config.getBridgePriority();
    }

    @Override
    public int getOspfPriority() {
        return m_config.getOspfPriority();
    }

    @Override
    public int getIsisPriority() {
        return m_config.getIsisPriority();
    }

    @Override
    public long getBridgeTopologyInterval() {
        return m_config.getBridgeTopologyInterval();
    }

    @Override
    public long getTopologyInterval() {
        return m_config.getTopologyInterval();
    }

    @Override
    public int getExecutorThreads() {
        if (m_config.getExecutorThreads() != null) {
            return m_config.getExecutorThreads();
        }
        return 5;
    }

    @Override
    public int getExecutorQueueSize() {
        if (m_config.getExecutorQueueSize() != null) {
            return m_config.getExecutorQueueSize();
        }
        return 100;
    }

    @Override
    public int getThreads() {
        if (m_config.getThreads() != null) {
            return m_config.getThreads();
        }
        return 3;
    }

    @Override
    public int getMaxBft() {
        if (m_config.getMaxBft() != null) {
            return m_config.getMaxBft();
        }
        return 100;
    }

    @Override
    public int getDiscoveryBridgeThreads() {
        if (m_config.getDiscoveryBridgeThreads() != null) {
            return m_config.getDiscoveryBridgeThreads();
        }
        return 1;
    }

    protected abstract void saveXml(String var1) throws IOException;
}

