/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.model;

import com.google.common.base.MoreObjects;
import java.io.Serializable;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.annotate.JsonIgnoreProperties;
import org.hibernate.ObjectNotFoundException;
import org.hibernate.annotations.Filter;
import org.hibernate.annotations.Type;
import org.opennms.core.network.InetAddressXmlAdapter;
import org.opennms.netmgt.events.api.EventParameterUtils;
import org.opennms.netmgt.model.EntityVisitor;
import org.opennms.netmgt.model.OnmsAlarm;
import org.opennms.netmgt.model.OnmsEntity;
import org.opennms.netmgt.model.OnmsEventParameter;
import org.opennms.netmgt.model.OnmsMonitoringSystem;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.OnmsNotification;
import org.opennms.netmgt.model.OnmsOutage;
import org.opennms.netmgt.model.OnmsServiceType;
import org.opennms.netmgt.model.OnmsSeverity;
import org.opennms.netmgt.xml.event.Event;
import org.opennms.netmgt.xml.event.Parm;

@XmlRootElement(name="event")
@Entity
@Table(name="events")
@Filter(name="authorizedOnly", condition="exists (select distinct x.nodeid from node x join category_node cn on x.nodeid = cn.nodeid join category_group cg on cn.categoryId = cg.categoryId where x.nodeid = nodeid and cg.groupId in (:userGroups))")
@JsonIgnoreProperties(value={"hibernateLazyInitializer", "handler"})
public class OnmsEvent
extends OnmsEntity
implements Serializable {
    private static final long serialVersionUID = -7412025003474162992L;
    @Id
    @Column(name="eventId", nullable=false)
    @SequenceGenerator(name="eventSequence", sequenceName="eventsNxtId")
    @GeneratedValue(generator="eventSequence")
    private Long eventId;
    @Column(name="eventUei", length=256, nullable=false)
    private String eventUei;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="eventTime", nullable=false)
    private Date eventTime;
    @Column(name="eventHost", length=256)
    private String eventHost;
    @Column(name="eventSource", length=128, nullable=false)
    private String eventSource;
    @Column(name="ipAddr")
    @Type(type="org.opennms.netmgt.model.InetAddressUserType")
    private InetAddress ipAddr;
    @ManyToOne
    @JoinColumn(name="systemId", nullable=false)
    private OnmsMonitoringSystem distPoller;
    @Column(name="eventSnmpHost", length=256)
    private String eventSnmpHost;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="serviceId", nullable=true)
    private OnmsServiceType serviceType;
    @Column(name="eventSnmp", length=256)
    private String eventSnmp;
    @OneToMany(mappedBy="event", cascade={CascadeType.ALL})
    private List<OnmsEventParameter> eventParameters;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="eventCreateTime", nullable=false)
    private Date eventCreateTime;
    @Column(name="eventDescr", length=4000)
    private String eventDescr;
    @Column(name="eventLogGroup", length=32)
    private String eventLogGroup;
    @Column(name="eventLogMsg", length=1024)
    private String eventLogMsg;
    @Column(name="eventSeverity", nullable=false)
    private Integer eventSeverity;
    @Column(name="ifIndex")
    private Integer ifIndex;
    @Column(name="eventPathOutage", length=1024)
    private String eventPathOutage;
    @Column(name="eventCorrelation", length=1024)
    private String eventCorrelation;
    @Column(name="eventSuppressedCount")
    private Integer eventSuppressedCount;
    @Column(name="eventOperInstruct")
    private String eventOperInstruct;
    @Column(name="eventAutoAction", length=256)
    private String eventAutoAction;
    @Column(name="eventOperAction", length=256)
    private String eventOperAction;
    @Column(name="eventOperActionMenuText", length=64)
    private String eventOperActionMenuText;
    @Column(name="eventNotification", length=128)
    private String eventNotification;
    @Column(name="eventTTicket", length=128)
    private String eventTTicket;
    @Column(name="eventTTicketState")
    private Integer eventTTicketState;
    @Column(name="eventForward", length=256)
    private String eventForward;
    @Column(name="eventMouseOverText", length=64)
    private String eventMouseOverText;
    @Column(name="eventLog", length=1, nullable=false)
    private String eventLog;
    @Column(name="eventDisplay", length=1, nullable=false)
    private String eventDisplay;
    @Column(name="eventAckUser", length=256)
    private String eventAckUser;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="eventAckTime")
    private Date eventAckTime;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="alarmId")
    private OnmsAlarm alarm;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="nodeId")
    private OnmsNode node;
    @OneToMany(mappedBy="event", fetch=FetchType.LAZY)
    private Set<OnmsNotification> notifications = new HashSet<OnmsNotification>();
    @OneToMany(mappedBy="serviceRegainedEvent", fetch=FetchType.LAZY)
    private Set<OnmsOutage> associatedServiceRegainedOutages = new HashSet<OnmsOutage>();
    @OneToMany(mappedBy="serviceLostEvent", fetch=FetchType.LAZY)
    private Set<OnmsOutage> associatedServiceLostOutages = new HashSet<OnmsOutage>();

    @XmlAttribute(name="id")
    public Long getId() {
        return this.eventId;
    }

    public void setId(Long eventid) {
        this.eventId = eventid;
    }

    @XmlElement(name="uei")
    public String getEventUei() {
        return this.eventUei;
    }

    public void setEventUei(String eventuei) {
        this.eventUei = eventuei;
    }

    @XmlElement(name="time")
    public Date getEventTime() {
        return this.eventTime;
    }

    public void setEventTime(Date eventtime) {
        this.eventTime = eventtime;
    }

    @XmlElement(name="host")
    public String getEventHost() {
        return this.eventHost;
    }

    public void setEventHost(String eventhost) {
        this.eventHost = eventhost;
    }

    @XmlElement(name="source")
    public String getEventSource() {
        return this.eventSource;
    }

    public void setEventSource(String eventsource) {
        this.eventSource = eventsource;
    }

    @XmlElement(name="ipAddress")
    @XmlJavaTypeAdapter(value=InetAddressXmlAdapter.class)
    public InetAddress getIpAddr() {
        return this.ipAddr;
    }

    public void setIpAddr(InetAddress ipaddr) {
        this.ipAddr = ipaddr;
    }

    @XmlTransient
    public OnmsMonitoringSystem getDistPoller() {
        return this.distPoller;
    }

    public void setDistPoller(OnmsMonitoringSystem distPoller) {
        this.distPoller = distPoller;
    }

    @XmlElement(name="snmpHost")
    public String getEventSnmpHost() {
        return this.eventSnmpHost;
    }

    public void setEventSnmpHost(String eventsnmphost) {
        this.eventSnmpHost = eventsnmphost;
    }

    public OnmsServiceType getServiceType() {
        return this.serviceType;
    }

    public void setServiceType(OnmsServiceType serviceType) {
        this.serviceType = serviceType;
    }

    @XmlElement(name="snmp")
    public String getEventSnmp() {
        return this.eventSnmp;
    }

    public void setEventSnmp(String eventsnmp) {
        this.eventSnmp = eventsnmp;
    }

    @XmlElementWrapper(name="parameters")
    @XmlElement(name="parameter")
    public List<OnmsEventParameter> getEventParameters() {
        if (this.eventParameters != null) {
            this.eventParameters.sort(Comparator.comparing(OnmsEventParameter::getPosition));
        }
        return this.eventParameters;
    }

    public void setEventParameters(List<OnmsEventParameter> eventParameters) {
        this.eventParameters = eventParameters;
        this.setPositionsOnParameters(this.eventParameters);
    }

    public void setEventParametersFromEvent(Event event) {
        this.eventParameters = EventParameterUtils.normalizePreserveOrder((List)event.getParmCollection()).stream().map(p -> new OnmsEventParameter(this, (Parm)p)).collect(Collectors.toList());
        this.setPositionsOnParameters(this.eventParameters);
    }

    public void addEventParameter(OnmsEventParameter parameter) {
        if (this.eventParameters == null) {
            this.eventParameters = new ArrayList<OnmsEventParameter>();
        }
        if (this.eventParameters.contains(parameter)) {
            this.eventParameters.remove(parameter);
        }
        this.eventParameters.add(parameter);
        this.setPositionsOnParameters(this.eventParameters);
    }

    private void setPositionsOnParameters(List<OnmsEventParameter> parameters) {
        if (parameters != null) {
            for (int i = 0; i < parameters.size(); ++i) {
                parameters.get(i).setPosition(i);
            }
        }
    }

    @XmlElement(name="createTime")
    public Date getEventCreateTime() {
        return this.eventCreateTime;
    }

    public void setEventCreateTime(Date eventcreatetime) {
        this.eventCreateTime = eventcreatetime;
    }

    @XmlElement(name="description")
    public String getEventDescr() {
        return this.eventDescr;
    }

    public void setEventDescr(String eventdescr) {
        this.eventDescr = eventdescr;
    }

    @XmlElement(name="logGroup")
    public String getEventLogGroup() {
        return this.eventLogGroup;
    }

    public void setEventLogGroup(String eventloggroup) {
        this.eventLogGroup = eventloggroup;
    }

    @XmlElement(name="logMessage")
    public String getEventLogMsg() {
        return this.eventLogMsg;
    }

    public void setEventLogMsg(String eventlogmsg) {
        this.eventLogMsg = eventlogmsg;
    }

    @XmlTransient
    public Integer getEventSeverity() {
        return this.eventSeverity;
    }

    public void setEventSeverity(Integer severity) {
        this.eventSeverity = severity;
    }

    @XmlAttribute(name="severity")
    public String getSeverityLabel() {
        return OnmsSeverity.get(this.eventSeverity).name();
    }

    public void setSeverityLabel(String label) {
        this.eventSeverity = OnmsSeverity.get(label).getId();
    }

    @XmlElement(name="pathOutage")
    public String getEventPathOutage() {
        return this.eventPathOutage;
    }

    public void setEventPathOutage(String eventpathoutage) {
        this.eventPathOutage = eventpathoutage;
    }

    @XmlElement(name="correlation")
    public String getEventCorrelation() {
        return this.eventCorrelation;
    }

    public void setEventCorrelation(String eventcorrelation) {
        this.eventCorrelation = eventcorrelation;
    }

    @XmlElement(name="suppressedCount")
    public Integer getEventSuppressedCount() {
        return this.eventSuppressedCount;
    }

    public void setEventSuppressedCount(Integer eventsuppressedcount) {
        this.eventSuppressedCount = eventsuppressedcount;
    }

    @XmlElement(name="operatorInstructions")
    public String getEventOperInstruct() {
        return this.eventOperInstruct;
    }

    public void setEventOperInstruct(String eventoperinstruct) {
        this.eventOperInstruct = eventoperinstruct;
    }

    @XmlElement(name="autoAction")
    public String getEventAutoAction() {
        return this.eventAutoAction;
    }

    public void setEventAutoAction(String eventautoaction) {
        this.eventAutoAction = eventautoaction;
    }

    @XmlElement(name="operatorAction")
    public String getEventOperAction() {
        return this.eventOperAction;
    }

    public void setEventOperAction(String eventoperaction) {
        this.eventOperAction = eventoperaction;
    }

    @XmlElement(name="operationActionMenuText")
    public String getEventOperActionMenuText() {
        return this.eventOperActionMenuText;
    }

    public void setEventOperActionMenuText(String eventOperActionMenuText) {
        this.eventOperActionMenuText = eventOperActionMenuText;
    }

    @XmlElement(name="notification")
    public String getEventNotification() {
        return this.eventNotification;
    }

    public void setEventNotification(String eventnotification) {
        this.eventNotification = eventnotification;
    }

    @XmlElement(name="troubleTicket")
    public String getEventTTicket() {
        return this.eventTTicket;
    }

    public void setEventTTicket(String eventtticket) {
        this.eventTTicket = eventtticket;
    }

    @XmlElement(name="troubleTicketState")
    public Integer getEventTTicketState() {
        return this.eventTTicketState;
    }

    public void setEventTTicketState(Integer eventtticketstate) {
        this.eventTTicketState = eventtticketstate;
    }

    @XmlTransient
    public String getEventForward() {
        return this.eventForward;
    }

    public void setEventForward(String eventforward) {
        this.eventForward = eventforward;
    }

    @XmlElement(name="mouseOverText")
    public String getEventMouseOverText() {
        return this.eventMouseOverText;
    }

    public void setEventMouseOverText(String eventmouseovertext) {
        this.eventMouseOverText = eventmouseovertext;
    }

    @XmlAttribute(name="log")
    public String getEventLog() {
        return this.eventLog;
    }

    public void setEventLog(String eventlog) {
        this.eventLog = eventlog;
    }

    @XmlAttribute(name="display")
    public String getEventDisplay() {
        return this.eventDisplay;
    }

    public void setEventDisplay(String eventdisplay) {
        this.eventDisplay = eventdisplay;
    }

    @XmlElement(name="ackUser")
    public String getEventAckUser() {
        return this.eventAckUser;
    }

    public void setEventAckUser(String eventackuser) {
        this.eventAckUser = eventackuser;
    }

    @XmlElement(name="ackTime")
    public Date getEventAckTime() {
        return this.eventAckTime;
    }

    public void setEventAckTime(Date eventacktime) {
        this.eventAckTime = eventacktime;
    }

    @XmlTransient
    public OnmsAlarm getAlarm() {
        return this.alarm;
    }

    public void setAlarm(OnmsAlarm alarm) {
        this.alarm = alarm;
    }

    @XmlTransient
    @JsonIgnore
    public OnmsNode getNode() {
        return this.node;
    }

    @XmlElement(name="nodeId")
    public Integer getNodeId() {
        try {
            return this.node != null ? this.node.getId() : null;
        }
        catch (ObjectNotFoundException e) {
            return null;
        }
    }

    @XmlElement(name="nodeLabel", required=false)
    public String getNodeLabel() {
        try {
            if (this.node == null) {
                return null;
            }
            return this.node.getLabel();
        }
        catch (ObjectNotFoundException e) {
            return "";
        }
    }

    public void setNode(OnmsNode node) {
        this.node = node;
    }

    @XmlTransient
    public Set<OnmsNotification> getNotifications() {
        return this.notifications;
    }

    public void setNotifications(Set<OnmsNotification> notifications) {
        this.notifications = notifications;
    }

    @XmlTransient
    public Set<OnmsOutage> getAssociatedServiceRegainedOutages() {
        return this.associatedServiceRegainedOutages;
    }

    public void setAssociatedServiceRegainedOutages(Set<OnmsOutage> outagesBySvcregainedeventid) {
        this.associatedServiceRegainedOutages = outagesBySvcregainedeventid;
    }

    @XmlTransient
    public Set<OnmsOutage> getAssociatedServiceLostOutages() {
        return this.associatedServiceLostOutages;
    }

    public void setAssociatedServiceLostOutages(Set<OnmsOutage> outagesBySvclosteventid) {
        this.associatedServiceLostOutages = outagesBySvclosteventid;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("eventid", (Object)this.getId()).add("eventuei", (Object)this.getEventUei()).toString();
    }

    @Override
    public void visit(EntityVisitor visitor) {
        throw new RuntimeException("visitor method not implemented");
    }

    public Integer getIfIndex() {
        return this.ifIndex;
    }

    public void setIfIndex(Integer ifIndex) {
        this.ifIndex = ifIndex;
    }
}

