/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.graph.service;

import java.util.Objects;
import org.opennms.netmgt.graph.api.ImmutableGraphContainer;
import org.opennms.netmgt.graph.api.generic.GenericGraph;
import org.opennms.netmgt.graph.api.generic.GenericGraphContainer;
import org.opennms.netmgt.graph.api.info.DefaultGraphContainerInfo;
import org.opennms.netmgt.graph.api.info.GraphContainerInfo;
import org.opennms.netmgt.graph.api.service.GraphContainerProvider;
import org.opennms.netmgt.graph.api.service.GraphProvider;

public class SingleGraphContainerProvider
implements GraphContainerProvider {
    private final GraphContainerInfo containerInfo;
    private final GraphProvider graphProvider;

    public SingleGraphContainerProvider(GraphProvider graphProvider, GraphContainerInfo containerInfo) {
        this.graphProvider = Objects.requireNonNull(graphProvider);
        this.containerInfo = Objects.requireNonNull(containerInfo);
    }

    public ImmutableGraphContainer loadGraphContainer() {
        GenericGraphContainer.GenericGraphContainerBuilder containerBuilder = GenericGraphContainer.builder().applyContainerInfo(this.getContainerInfo());
        GenericGraph graph = this.graphProvider.loadGraph().asGenericGraph();
        if (graph != null) {
            containerBuilder.addGraph(graph);
        }
        return containerBuilder.build();
    }

    public GraphContainerInfo getContainerInfo() {
        DefaultGraphContainerInfo containerInfo = new DefaultGraphContainerInfo(this.containerInfo.getId());
        containerInfo.setDescription(this.containerInfo.getDescription());
        containerInfo.setLabel(this.containerInfo.getLabel());
        containerInfo.getGraphInfos().add(this.graphProvider.getGraphInfo());
        return containerInfo;
    }
}

