/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.graph.persistence.mapper;

import org.opennms.netmgt.graph.FocusEntity;
import org.opennms.netmgt.graph.GraphContainerEntity;
import org.opennms.netmgt.graph.GraphEntity;
import org.opennms.netmgt.graph.PropertyEntity;
import org.opennms.netmgt.graph.api.VertexRef;
import org.opennms.netmgt.graph.api.generic.GenericEdge;
import org.opennms.netmgt.graph.api.generic.GenericGraph;
import org.opennms.netmgt.graph.api.generic.GenericGraphContainer;
import org.opennms.netmgt.graph.api.generic.GenericVertex;
import org.opennms.netmgt.graph.persistence.converter.ConverterService;

public class EntityToGenericMapper {
    private ConverterService converterService = new ConverterService();

    public GenericGraphContainer fromEntity(GraphContainerEntity entity) {
        GenericGraphContainer.GenericGraphContainerBuilder genericGraphContainerBuilder = GenericGraphContainer.builder();
        entity.getProperties().forEach(property -> {
            Object value = this.convert((PropertyEntity)property);
            genericGraphContainerBuilder.property(property.getName(), value);
        });
        entity.getGraphs().forEach(graphEntity -> {
            GenericGraph genericGraph = this.fromEntity((GraphEntity)graphEntity);
            genericGraphContainerBuilder.addGraph(genericGraph);
        });
        return genericGraphContainerBuilder.build();
    }

    public GenericGraph fromEntity(GraphEntity graphEntity) {
        GenericGraph.GenericGraphBuilder genericGraphBuilder = GenericGraph.builder().namespace(graphEntity.getNamespace());
        graphEntity.getProperties().forEach(property -> {
            Object value = this.convert((PropertyEntity)property);
            genericGraphBuilder.property(property.getName(), value);
        });
        graphEntity.getVertices().stream().forEach(vertexEntity -> {
            GenericVertex.GenericVertexBuilder genericVertex = ((GenericVertex.GenericVertexBuilder)GenericVertex.builder().namespace(graphEntity.getNamespace())).id(vertexEntity.getProperty("id").getValue());
            vertexEntity.getProperties().forEach(property -> {
                Object value = this.convert((PropertyEntity)property);
                genericVertex.property(property.getName(), value);
            });
            genericGraphBuilder.addVertex(genericVertex.build());
        });
        graphEntity.getEdges().stream().forEach(edgeEntity -> {
            GenericEdge.GenericEdgeBuilder genericEdge = ((GenericEdge.GenericEdgeBuilder)GenericEdge.builder().namespace(edgeEntity.getNamespace())).source(new VertexRef(edgeEntity.getSource().getNamespace(), edgeEntity.getSource().getId())).target(new VertexRef(edgeEntity.getTarget().getNamespace(), edgeEntity.getTarget().getId()));
            edgeEntity.getProperties().stream().forEach(property -> {
                Object value = this.convert((PropertyEntity)property);
                genericEdge.property(property.getName(), value);
            });
            genericGraphBuilder.addEdge(genericEdge.build());
        });
        FocusEntity focusEntity = graphEntity.getDefaultFocus();
        if (focusEntity == null || focusEntity.getType().equalsIgnoreCase("EMPTY")) {
            genericGraphBuilder.focus().empty().apply();
        } else if (focusEntity.getType().equalsIgnoreCase("FIRST")) {
            genericGraphBuilder.focus().first().apply();
        } else if (focusEntity.getType().equalsIgnoreCase("ALL")) {
            genericGraphBuilder.focus().all().apply();
        } else if (focusEntity.getType().equalsIgnoreCase("SELECTION")) {
            genericGraphBuilder.focus().selection(genericGraphBuilder.getNamespace(), focusEntity.getVertexIds()).apply();
        } else {
            throw new IllegalStateException("The focus strategy '" + focusEntity.getType() + "' read from persistence is not known.");
        }
        return genericGraphBuilder.build();
    }

    public Object convert(PropertyEntity propertyEntity) {
        Object value = this.converterService.toValue(propertyEntity.getType(), propertyEntity.getValue());
        return value;
    }
}

