/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.graph.persistence;

import java.util.List;
import java.util.Objects;
import org.opennms.netmgt.dao.api.SessionUtils;
import org.opennms.netmgt.graph.EdgeEntity;
import org.opennms.netmgt.graph.FocusEntity;
import org.opennms.netmgt.graph.GraphContainerEntity;
import org.opennms.netmgt.graph.GraphEntity;
import org.opennms.netmgt.graph.PropertyEntity;
import org.opennms.netmgt.graph.VertexEntity;
import org.opennms.netmgt.graph.api.ImmutableGraphContainer;
import org.opennms.netmgt.graph.api.focus.Focus;
import org.opennms.netmgt.graph.api.generic.GenericEdge;
import org.opennms.netmgt.graph.api.generic.GenericGraph;
import org.opennms.netmgt.graph.api.generic.GenericGraphContainer;
import org.opennms.netmgt.graph.api.generic.GenericVertex;
import org.opennms.netmgt.graph.api.info.DefaultGraphContainerInfo;
import org.opennms.netmgt.graph.api.info.DefaultGraphInfo;
import org.opennms.netmgt.graph.api.info.GraphContainerInfo;
import org.opennms.netmgt.graph.api.info.GraphInfo;
import org.opennms.netmgt.graph.api.persistence.GraphRepository;
import org.opennms.netmgt.graph.api.updates.ContainerChangeSet;
import org.opennms.netmgt.graph.dao.api.GraphContainerDao;
import org.opennms.netmgt.graph.persistence.mapper.EntityToGenericMapper;
import org.opennms.netmgt.graph.persistence.mapper.GenericToEntityMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultGraphRepository
implements GraphRepository {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultGraphRepository.class);
    private final EntityToGenericMapper entityToGenericMapper = new EntityToGenericMapper();
    private final GenericToEntityMapper genericToEntityMapper = new GenericToEntityMapper();
    private final GraphContainerDao graphContainerDao;
    private final SessionUtils sessionUtils;

    public DefaultGraphRepository(SessionUtils sessionUtils, GraphContainerDao graphContainerDao) {
        this.graphContainerDao = Objects.requireNonNull(graphContainerDao);
        this.sessionUtils = Objects.requireNonNull(sessionUtils);
    }

    public GenericGraphContainer findContainerById(String containerId) {
        return (GenericGraphContainer)this.sessionUtils.withTransaction(() -> {
            GraphContainerEntity entity = this.graphContainerDao.findContainerById(containerId);
            if (entity != null) {
                return this.entityToGenericMapper.fromEntity(entity);
            }
            return null;
        });
    }

    public GraphContainerInfo findContainerInfoById(String containerId) {
        return (GraphContainerInfo)this.sessionUtils.withTransaction(() -> {
            GraphContainerEntity containerEntity = this.graphContainerDao.findContainerInfoById(containerId);
            if (containerEntity != null) {
                DefaultGraphContainerInfo containerInfo = new DefaultGraphContainerInfo(containerEntity.getNamespace());
                containerInfo.setLabel(containerEntity.getLabel());
                containerInfo.setDescription(containerEntity.getDescription());
                containerEntity.getGraphs().forEach(graphEntity -> {
                    DefaultGraphInfo graphInfo = new DefaultGraphInfo(graphEntity.getNamespace());
                    graphInfo.setLabel(graphEntity.getLabel());
                    graphInfo.setDescription(graphEntity.getDescription());
                    containerInfo.getGraphInfos().add(graphInfo);
                });
                return containerInfo;
            }
            return null;
        });
    }

    public void deleteContainer(String containerId) {
        this.graphContainerDao.delete(containerId);
    }

    public void save(ImmutableGraphContainer graphContainer) {
        this.sessionUtils.withTransaction(() -> {
            GenericGraphContainer persistedGraphContainer = this.findContainerById(graphContainer.getId());
            GenericGraphContainer genericGraphContainer = graphContainer.asGenericGraphContainer();
            if (persistedGraphContainer == null) {
                LOG.debug("Graph Container (id: {}) is new. Persisting...", (Object)graphContainer.getId());
                GraphContainerEntity graphContainerEntity = this.genericToEntityMapper.toEntity(genericGraphContainer);
                this.graphContainerDao.save(graphContainerEntity);
                LOG.debug("Graph Container (id: {}) persisted.", (Object)graphContainer.getId());
            } else {
                LOG.debug("Graph Container (id: {}) exists. Calculating change set...", (Object)graphContainer.getId());
                ContainerChangeSet containerChangeSet = ContainerChangeSet.builder((ImmutableGraphContainer)persistedGraphContainer, (ImmutableGraphContainer)genericGraphContainer).build();
                if (containerChangeSet.hasChanges()) {
                    GraphContainerEntity graphContainerEntity = this.graphContainerDao.findContainerById(graphContainer.getId());
                    containerChangeSet.getGraphsRemoved().forEach(genericGraph -> {
                        GraphEntity entity = graphContainerEntity.getGraph(genericGraph.getNamespace());
                        graphContainerEntity.getGraphs().remove(entity);
                    });
                    containerChangeSet.getGraphsAdded().forEach(genericGraph -> {
                        GraphEntity newGraphEntity = this.genericToEntityMapper.toEntity((GenericGraph)genericGraph);
                        graphContainerEntity.getGraphs().add(newGraphEntity);
                    });
                    containerChangeSet.getGraphsUpdated().forEach(changeSet -> {
                        GraphEntity graphEntity = graphContainerEntity.getGraph(changeSet.getNamespace());
                        if (changeSet.getGraphInfo() != null) {
                            GraphInfo graphInfo = changeSet.getGraphInfo();
                            graphEntity.setProperty("namespace", String.class, graphInfo.getNamespace());
                            graphEntity.setProperty("label", String.class, graphInfo.getLabel());
                            graphEntity.setProperty("description", String.class, graphInfo.getDescription());
                        }
                        if (changeSet.hasFocusChanged()) {
                            Focus focus = changeSet.getFocus();
                            FocusEntity focusEntity = graphEntity.getDefaultFocus();
                            focusEntity.setType(focus.getId());
                            focusEntity.setSelection(focus.getVertexIds());
                        }
                        changeSet.getEdgesRemoved().forEach(edge -> {
                            EdgeEntity edgeEntity = graphEntity.getEdgeByProperty("id", edge.getId());
                            graphEntity.removeEdge(edgeEntity);
                        });
                        changeSet.getEdgesAdded().forEach(edge -> {
                            EdgeEntity edgeEntity = this.genericToEntityMapper.toEntity((GenericEdge)edge, graphEntity);
                            graphEntity.addEdge(edgeEntity);
                        });
                        changeSet.getEdgesUpdated().forEach(edge -> {
                            EdgeEntity edgeEntity = graphEntity.getEdgeByProperty("id", edge.getId());
                            List<PropertyEntity> propertyEntities = this.genericToEntityMapper.convertToPropertyEntities(((GenericEdge)edge).getProperties());
                            edgeEntity.mergeProperties(propertyEntities);
                        });
                        changeSet.getVerticesRemoved().forEach(vertex -> {
                            VertexEntity vertexEntity = graphEntity.getVertexByProperty("id", vertex.getId());
                            graphEntity.removeVertex(vertexEntity);
                        });
                        changeSet.getVerticesAdded().forEach(vertex -> {
                            VertexEntity vertexEntity = this.genericToEntityMapper.toEntity((GenericVertex)vertex);
                            graphEntity.addVertex(vertexEntity);
                        });
                        changeSet.getVerticesUpdated().forEach(vertex -> {
                            VertexEntity vertexEntity = graphEntity.getVertexByProperty("id", vertex.getId());
                            List<PropertyEntity> propertyEntities = this.genericToEntityMapper.convertToPropertyEntities(((GenericVertex)vertex).getProperties());
                            vertexEntity.mergeProperties(propertyEntities);
                        });
                    });
                    this.graphContainerDao.update(graphContainerEntity);
                }
                LOG.debug("Graph Container (id: {}) updated.", (Object)graphContainer.getId());
            }
            return null;
        });
    }

    public void save(GraphContainerInfo containerInfo) {
        GenericGraphContainer.GenericGraphContainerBuilder genericGraphContainerBuilder = GenericGraphContainer.builder().description(containerInfo.getDescription()).label(containerInfo.getLabel()).id(containerInfo.getId());
        containerInfo.getGraphInfos().forEach(graphInfo -> {
            GenericGraph genericGraph = GenericGraph.builder().namespace(graphInfo.getNamespace()).property("label", (Object)graphInfo.getLabel()).property("description", (Object)graphInfo.getDescription()).build();
            genericGraphContainerBuilder.addGraph(genericGraph);
        });
        this.save((ImmutableGraphContainer)genericGraphContainerBuilder.build());
    }
}

