/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.vaadin.dashboard.model;

import com.vaadin.ui.Component;
import com.vaadin.ui.VerticalLayout;
import com.vaadin.v7.shared.ui.label.ContentMode;
import com.vaadin.v7.ui.Label;
import java.util.Map;
import java.util.TreeMap;
import org.opennms.features.vaadin.dashboard.config.ui.PropertiesWindow;
import org.opennms.features.vaadin.dashboard.model.DashletConfigurationWindow;
import org.opennms.features.vaadin.dashboard.model.DashletFactory;
import org.opennms.features.vaadin.dashboard.model.DashletSpec;

public abstract class AbstractDashletFactory
implements DashletFactory {
    protected String m_name;
    protected Map<String, String> m_requiredParameters = new TreeMap<String, String>();
    protected Map<String, String> m_requiredParameterDescriptions = new TreeMap<String, String>();
    protected boolean m_boostable = true;
    protected boolean m_dashboardSuitable = false;

    public AbstractDashletFactory() {
    }

    public AbstractDashletFactory(String name) {
        this.m_name = name;
    }

    protected void addRequiredParameter(String key, String defaultValue) {
        this.m_requiredParameters.put(key, defaultValue);
    }

    @Override
    public String getName() {
        return this.m_name;
    }

    public void setName(String name) {
        this.m_name = name;
    }

    @Override
    public Map<String, String> getRequiredParameters() {
        return this.m_requiredParameters;
    }

    public Map<String, String> getRequiredParameterDescriptions() {
        return this.m_requiredParameterDescriptions;
    }

    public void setRequiredParameters(Map<String, String> requiredParameters) {
        this.m_requiredParameters = new TreeMap<String, String>(requiredParameters);
    }

    public void setRequiredParameterDescriptions(Map<String, String> requiredParameterDescriptions) {
        this.m_requiredParameterDescriptions = requiredParameterDescriptions;
    }

    public void setBoostable(boolean boostable) {
        this.m_boostable = boostable;
    }

    public void setDashboardSuitable(boolean dashletSuitable) {
        this.m_dashboardSuitable = dashletSuitable;
    }

    @Override
    public boolean isSuitableForDashboard() {
        return this.m_dashboardSuitable;
    }

    @Override
    public boolean isBoostable() {
        return this.m_boostable;
    }

    @Override
    public boolean providesHelpComponent() {
        return true;
    }

    @Override
    public Component getHelpComponent() {
        VerticalLayout verticalLayout = new VerticalLayout();
        Label helpContent = new Label(this.getHelpContentHTML(), ContentMode.HTML);
        helpContent.addStyleName("help-content");
        Label helpParameters = new Label(this.getParameterDescriptionsHTML(), ContentMode.HTML);
        helpParameters.addStyleName("help-content");
        verticalLayout.addComponent((Component)helpContent);
        verticalLayout.addComponent((Component)helpParameters);
        return verticalLayout;
    }

    public abstract String getHelpContentHTML();

    private String getParameterDescriptionsHTML() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.m_requiredParameters.size() == 0) {
            return "";
        }
        stringBuilder.append("<br/><table class='help-table'>");
        stringBuilder.append("<tr>");
        stringBuilder.append("<th>Name</th>");
        stringBuilder.append("<th>Default</th>");
        stringBuilder.append("<th>Description</th>");
        stringBuilder.append("</tr>");
        for (Map.Entry<String, String> entry : this.m_requiredParameters.entrySet()) {
            stringBuilder.append("<tr>");
            stringBuilder.append("<td class='help-table-cell'>" + entry.getKey() + "</td>");
            String value = entry.getValue();
            if (value.length() > 20) {
                value = value.substring(0, 19) + "...";
            }
            stringBuilder.append("<td class='help-table-cell'>'" + value + "'</td>");
            if (this.getRequiredParameterDescriptions().containsKey(entry.getKey())) {
                stringBuilder.append("<td class='help-table-cell'>" + this.getRequiredParameterDescriptions().get(entry.getKey()) + "</td>");
            } else {
                stringBuilder.append("<td class='help-table-cell'>-</td>");
            }
            stringBuilder.append("</tr>");
        }
        stringBuilder.append("</table>");
        return stringBuilder.toString();
    }

    @Override
    public DashletConfigurationWindow configurationWindow(DashletSpec dashletSpec) {
        return new PropertiesWindow(dashletSpec, this);
    }
}

