/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.vaadin.dashboard.config.ui.editors;

import java.util.ArrayList;
import java.util.HashSet;
import org.opennms.core.criteria.CriteriaBuilder;
import org.opennms.features.vaadin.dashboard.config.ui.editors.CriteriaBuilderHelper;
import org.opennms.features.vaadin.dashboard.config.ui.editors.CriteriaEntry;
import org.slf4j.LoggerFactory;

public enum CriteriaRestriction {
    Asc(new CriteriaEntry[0]){

        @Override
        public void addRestriction(String property, CriteriaBuilderHelper criteriaBuilderHelper, CriteriaBuilder criteriaBuilder, Object[] values) {
            criteriaBuilder.asc();
        }
    }
    ,
    Desc(new CriteriaEntry[0]){

        @Override
        public void addRestriction(String property, CriteriaBuilderHelper criteriaBuilderHelper, CriteriaBuilder criteriaBuilder, Object[] values) {
            criteriaBuilder.desc();
        }
    }
    ,
    Between(new CriteriaEntry[]{CriteriaEntry.Property, CriteriaEntry.Value, CriteriaEntry.Value}){

        @Override
        public void addRestriction(String property, CriteriaBuilderHelper criteriaBuilderHelper, CriteriaBuilder criteriaBuilder, Object[] values) {
            criteriaBuilder.between(values[0].toString(), values[1], values[2]);
        }
    }
    ,
    Contains(new CriteriaEntry[]{CriteriaEntry.Property, CriteriaEntry.StringValue}){

        @Override
        public void addRestriction(String property, CriteriaBuilderHelper criteriaBuilderHelper, CriteriaBuilder criteriaBuilder, Object[] values) {
            criteriaBuilder.contains(values[0].toString(), values[1]);
        }
    }
    ,
    Distinct(new CriteriaEntry[0]){

        @Override
        public void addRestriction(String property, CriteriaBuilderHelper criteriaBuilderHelper, CriteriaBuilder criteriaBuilder, Object[] values) {
            criteriaBuilder.distinct();
        }
    }
    ,
    Eq(new CriteriaEntry[]{CriteriaEntry.Property, CriteriaEntry.Value}){

        @Override
        public void addRestriction(String property, CriteriaBuilderHelper criteriaBuilderHelper, CriteriaBuilder criteriaBuilder, Object[] values) {
            criteriaBuilder.eq(values[0].toString(), values[1]);
        }
    }
    ,
    Ge(new CriteriaEntry[]{CriteriaEntry.Property, CriteriaEntry.Value}){

        @Override
        public void addRestriction(String property, CriteriaBuilderHelper criteriaBuilderHelper, CriteriaBuilder criteriaBuilder, Object[] values) {
            criteriaBuilder.ge(values[0].toString(), values[1]);
        }
    }
    ,
    Gt(new CriteriaEntry[]{CriteriaEntry.Property, CriteriaEntry.Value}){

        @Override
        public void addRestriction(String property, CriteriaBuilderHelper criteriaBuilderHelper, CriteriaBuilder criteriaBuilder, Object[] values) {
            criteriaBuilder.gt(values[0].toString(), values[1]);
        }
    }
    ,
    Ilike(new CriteriaEntry[]{CriteriaEntry.Property, CriteriaEntry.StringValue}){

        @Override
        public void addRestriction(String property, CriteriaBuilderHelper criteriaBuilderHelper, CriteriaBuilder criteriaBuilder, Object[] values) {
            criteriaBuilder.ilike(values[0].toString(), values[1]);
        }
    }
    ,
    In(new CriteriaEntry[]{CriteriaEntry.Property, CriteriaEntry.StringValue}){

        @Override
        public void addRestriction(String property, CriteriaBuilderHelper criteriaBuilderHelper, CriteriaBuilder criteriaBuilder, Object[] values) {
            HashSet<Object> set = new HashSet<Object>();
            Class<?> clazz = criteriaBuilderHelper.getTypeOfProperty(property);
            for (String string : String.valueOf(values[1]).split("\\|")) {
                set.add(criteriaBuilderHelper.parseCriteriaValue(clazz, string));
            }
            criteriaBuilder.in(values[0].toString(), set);
        }
    }
    ,
    Iplike(new CriteriaEntry[]{CriteriaEntry.Property, CriteriaEntry.StringValue}){

        @Override
        public void addRestriction(String property, CriteriaBuilderHelper criteriaBuilderHelper, CriteriaBuilder criteriaBuilder, Object[] values) {
            criteriaBuilder.iplike(values[0].toString(), values[1]);
        }
    }
    ,
    IsNull(new CriteriaEntry[]{CriteriaEntry.Property}){

        @Override
        public void addRestriction(String property, CriteriaBuilderHelper criteriaBuilderHelper, CriteriaBuilder criteriaBuilder, Object[] values) {
            criteriaBuilder.isNull(values[0].toString());
        }
    }
    ,
    IsNotNull(new CriteriaEntry[]{CriteriaEntry.Property}){

        @Override
        public void addRestriction(String property, CriteriaBuilderHelper criteriaBuilderHelper, CriteriaBuilder criteriaBuilder, Object[] values) {
            criteriaBuilder.isNotNull(values[0].toString());
        }
    }
    ,
    Le(new CriteriaEntry[]{CriteriaEntry.Property, CriteriaEntry.Value}){

        @Override
        public void addRestriction(String property, CriteriaBuilderHelper criteriaBuilderHelper, CriteriaBuilder criteriaBuilder, Object[] values) {
            criteriaBuilder.le(values[0].toString(), values[1]);
        }
    }
    ,
    Lt(new CriteriaEntry[]{CriteriaEntry.Property, CriteriaEntry.Value}){

        @Override
        public void addRestriction(String property, CriteriaBuilderHelper criteriaBuilderHelper, CriteriaBuilder criteriaBuilder, Object[] values) {
            criteriaBuilder.lt(values[0].toString(), values[1]);
        }
    }
    ,
    Like(new CriteriaEntry[]{CriteriaEntry.Property, CriteriaEntry.StringValue}){

        @Override
        public void addRestriction(String property, CriteriaBuilderHelper criteriaBuilderHelper, CriteriaBuilder criteriaBuilder, Object[] values) {
            criteriaBuilder.like(values[0].toString(), values[1]);
        }
    }
    ,
    Limit(new CriteriaEntry[]{CriteriaEntry.IntegerValue}){

        @Override
        public void addRestriction(String property, CriteriaBuilderHelper criteriaBuilderHelper, CriteriaBuilder criteriaBuilder, Object[] values) {
            criteriaBuilder.limit(Integer.valueOf(values[0].toString()));
        }
    }
    ,
    Ne(new CriteriaEntry[]{CriteriaEntry.Property, CriteriaEntry.Value}){

        @Override
        public void addRestriction(String property, CriteriaBuilderHelper criteriaBuilderHelper, CriteriaBuilder criteriaBuilder, Object[] values) {
            criteriaBuilder.ne(values[0].toString(), values[1]);
        }
    }
    ,
    Not(new CriteriaEntry[0]){

        @Override
        public void addRestriction(String property, CriteriaBuilderHelper criteriaBuilderHelper, CriteriaBuilder criteriaBuilder, Object[] values) {
            criteriaBuilder.not();
        }
    }
    ,
    OrderBy(new CriteriaEntry[]{CriteriaEntry.Property}){

        @Override
        public void addRestriction(String property, CriteriaBuilderHelper criteriaBuilderHelper, CriteriaBuilder criteriaBuilder, Object[] values) {
            criteriaBuilder.orderBy(values[0].toString());
        }
    };

    private CriteriaEntry[] m_entries;

    private CriteriaRestriction(CriteriaEntry ... entries) {
        this.m_entries = entries;
    }

    public static CriteriaRestriction valueOfIgnoreCase(String name) {
        for (CriteriaRestriction criteriaRestriction : CriteriaRestriction.values()) {
            if (!criteriaRestriction.name().equalsIgnoreCase(name)) continue;
            return criteriaRestriction;
        }
        throw new IllegalArgumentException("No enum constant " + name + " found");
    }

    public CriteriaEntry[] getEntries() {
        return this.m_entries;
    }

    public void addRestrictionToCriteriaBuilder(CriteriaBuilderHelper criteriaBuilderHelper, CriteriaBuilder criteriaBuilder, String[] values) {
        ArrayList<Object> listOfObjects = new ArrayList<Object>();
        int i = 0;
        String property = null;
        for (CriteriaEntry entry : this.getEntries()) {
            switch (entry) {
                case Property: {
                    property = values[i];
                    listOfObjects.add(values[i]);
                    break;
                }
                case Value: {
                    Class clazz = criteriaBuilderHelper.getTypeOfProperty(property);
                    Object object = criteriaBuilderHelper.parseCriteriaValue(clazz, values[i]);
                    if (object == null) {
                        LoggerFactory.getLogger(CriteriaBuilderHelper.class).warn("Cannot parse value '" + values[i] + "' for class " + clazz.getSimpleName());
                        return;
                    }
                    listOfObjects.add(object);
                    break;
                }
                case IntegerValue: {
                    Class clazz = Integer.class;
                    Object object = criteriaBuilderHelper.parseCriteriaValue(clazz, values[i]);
                    if (object == null) {
                        LoggerFactory.getLogger(CriteriaBuilderHelper.class).warn("Cannot parse value '" + values[i] + "' for class " + clazz.getSimpleName());
                        return;
                    }
                    listOfObjects.add(object);
                    break;
                }
                case StringValue: {
                    Class clazz = String.class;
                    Object object = criteriaBuilderHelper.parseCriteriaValue(clazz, values[i]);
                    if (object == null) {
                        LoggerFactory.getLogger(CriteriaBuilderHelper.class).warn("Cannot parse value '" + values[i] + "' for class " + clazz.getSimpleName());
                        return;
                    }
                    listOfObjects.add(object);
                    break;
                }
            }
            ++i;
        }
        this.addRestriction(property, criteriaBuilderHelper, criteriaBuilder, listOfObjects.toArray());
    }

    public abstract void addRestriction(String var1, CriteriaBuilderHelper var2, CriteriaBuilder var3, Object[] var4);
}

