/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.container.jaas;

import java.util.concurrent.atomic.AtomicReference;
import org.opennms.netmgt.config.GroupDao;
import org.opennms.netmgt.config.api.UserConfig;
import org.opennms.web.springframework.security.SpringSecurityUserDao;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JaasSupport {
    private static final Logger LOG = LoggerFactory.getLogger(JaasSupport.class);
    private static AtomicReference<BundleContext> m_context = new AtomicReference();
    private static AtomicReference<UserConfig> m_userConfig = new AtomicReference();
    private static AtomicReference<GroupDao> m_groupDao = new AtomicReference();
    private static AtomicReference<SpringSecurityUserDao> m_userDao = new AtomicReference();

    private JaasSupport() {
    }

    public static synchronized void setContext(BundleContext context) {
        m_context.set(context);
        m_userConfig.set(null);
        m_groupDao.set(null);
        m_userDao.set(null);
    }

    public static synchronized BundleContext getContext() {
        BundleContext context = m_context.get();
        if (context != null) {
            return context;
        }
        JaasSupport.setContext(FrameworkUtil.getBundle(JaasSupport.class).getBundleContext());
        return m_context.get();
    }

    public static UserConfig getUserConfig() {
        UserConfig userConfig = m_userConfig.get();
        if (userConfig != null) {
            return userConfig;
        }
        m_userConfig.set(JaasSupport.getFromRegistry(UserConfig.class));
        return m_userConfig.get();
    }

    public static SpringSecurityUserDao getSpringSecurityUserDao() {
        SpringSecurityUserDao userDao = m_userDao.get();
        if (userDao != null) {
            return userDao;
        }
        m_userDao.set(JaasSupport.getFromRegistry(SpringSecurityUserDao.class));
        return m_userDao.get();
    }

    public static GroupDao getGroupDao() {
        GroupDao groupDao = m_groupDao.get();
        if (groupDao != null) {
            return groupDao;
        }
        m_groupDao.set(JaasSupport.getFromRegistry(GroupDao.class));
        return m_groupDao.get();
    }

    private static <T> T getFromRegistry(Class<T> clazz) {
        BundleContext context = m_context.get();
        if (context == null) {
            LOG.warn("No bundle context.  Unable to get class {} from the registry.", clazz);
            return null;
        }
        ServiceReference ref = context.getServiceReference(clazz);
        return (T)context.getService(ref);
    }
}

