/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.grpc.exporter.spog;

import java.util.List;
import org.opennms.core.utils.SystemInfoUtils;
import org.opennms.features.grpc.exporter.mapper.AlarmMapper;
import org.opennms.features.grpc.exporter.spog.SpogGrpcClient;
import org.opennms.integration.api.v1.runtime.RuntimeInfo;
import org.opennms.netmgt.alarmd.api.AlarmLifecycleListener;
import org.opennms.netmgt.model.OnmsAlarm;
import org.opennms.plugin.grpc.proto.spog.AlarmUpdateList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AlarmExporter
implements AlarmLifecycleListener {
    private static final Logger LOG = LoggerFactory.getLogger(AlarmExporter.class);
    private final RuntimeInfo runtimeInfo;
    private final SpogGrpcClient client;
    private final boolean alarmExportEnabled;

    public AlarmExporter(RuntimeInfo runtimeInfo, SpogGrpcClient client, boolean alarmExportEnabled) {
        this.runtimeInfo = runtimeInfo;
        this.client = client;
        this.alarmExportEnabled = alarmExportEnabled;
    }

    public void handleAlarmSnapshot(List<OnmsAlarm> alarms) {
        this.sendAlarmsSnapshot(alarms);
    }

    public void preHandleAlarmSnapshot() {
    }

    public void postHandleAlarmSnapshot() {
    }

    public void handleNewOrUpdatedAlarm(OnmsAlarm alarm) {
        this.sendAddUpdateAlarms(List.of(alarm));
    }

    public void handleDeletedAlarm(int alarmId, String reductionKey) {
    }

    public void sendAlarmsSnapshot(List<OnmsAlarm> alarms) {
        if (!this.client.isEnabled()) {
            LOG.debug("SPOG service disabled, not sending alarm snapshot");
            return;
        }
        if (!this.alarmExportEnabled) {
            LOG.debug("Alarm export disabled, not sending alarm snapshot");
            return;
        }
        AlarmUpdateList alarmUpdates = AlarmMapper.INSTANCE.toAlarmUpdatesList(alarms, this.runtimeInfo, SystemInfoUtils.getInstanceId(), true);
        this.client.sendAlarmUpdate(alarmUpdates);
    }

    public void sendAddUpdateAlarms(List<OnmsAlarm> onmsAlarms) {
        if (!this.client.isEnabled()) {
            LOG.debug("SPOG service disabled, not sending alarm updates");
            return;
        }
        if (!this.alarmExportEnabled) {
            LOG.debug("Alarm export disabled, not sending alarm updates");
            return;
        }
        AlarmUpdateList alarms = AlarmMapper.INSTANCE.toAlarmUpdatesList(onmsAlarms, this.runtimeInfo, SystemInfoUtils.getInstanceId(), false);
        this.client.sendAlarmUpdate(alarms);
    }
}

