/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.grpc.exporter.mapper;

import java.net.InetAddress;
import java.util.List;
import org.opennms.features.grpc.exporter.mapper.EventsMapper;
import org.opennms.integration.api.v1.runtime.RuntimeInfo;
import org.opennms.netmgt.events.api.model.IEvent;
import org.opennms.netmgt.events.api.model.ILogMsg;
import org.opennms.netmgt.events.api.model.IParm;
import org.opennms.netmgt.events.api.model.ISnmp;
import org.opennms.netmgt.events.api.model.IValue;
import org.opennms.plugin.grpc.proto.spog.Event;
import org.opennms.plugin.grpc.proto.spog.EventParameter;
import org.opennms.plugin.grpc.proto.spog.EventUpdateList;
import org.opennms.plugin.grpc.proto.spog.SnmpInfo;

public class EventsMapperImpl
implements EventsMapper {
    @Override
    public Event mapEvent(IEvent event) {
        String hostAddress;
        String content;
        if (event == null) {
            return null;
        }
        Event.Builder event1 = Event.newBuilder();
        if (event.hasDbid()) {
            event1.setId(event.getDbid());
        }
        if (event.getHost() != null) {
            event1.setLabel(event.getHost());
        }
        if (event.getCreationTime() != null) {
            event1.setCreateTime(this.mapDate(event.getCreationTime()));
        }
        if (event.getDescr() != null) {
            event1.setDescription(event.getDescr());
        }
        if ((content = this.eventLogmsgContent(event)) != null) {
            event1.setLogMessage(content);
        }
        if ((hostAddress = this.eventInterfaceAddressHostAddress(event)) != null) {
            event1.setIpAddress(hostAddress);
        }
        if (event.getSnmp() != null) {
            event1.setSnmpInfo(this.mapSnmpInfo(event.getSnmp()));
        }
        if (event.getParmCollection() != null) {
            for (IParm parmCollection : event.getParmCollection()) {
                event1.addParameter(this.mapEventParameter(parmCollection));
            }
        }
        if (event.hasNodeid()) {
            event1.setNodeId(event.getNodeid());
        }
        if (event.getUei() != null) {
            event1.setUei(event.getUei());
        }
        if (event.getTime() != null) {
            event1.setTime(this.mapDate(event.getTime()));
        }
        if (event.getSource() != null) {
            event1.setSource(event.getSource());
        }
        if (event.getDistPoller() != null) {
            event1.setDistPoller(event.getDistPoller());
        }
        event1.setSeverity(this.mapSeverity(event.getSeverity()));
        return event1.build();
    }

    @Override
    public SnmpInfo mapSnmpInfo(ISnmp snmp) {
        if (snmp == null) {
            return null;
        }
        SnmpInfo.Builder snmpInfo = SnmpInfo.newBuilder();
        if (snmp.getId() != null) {
            snmpInfo.setId(snmp.getId());
        }
        if (snmp.getVersion() != null) {
            snmpInfo.setVersion(snmp.getVersion());
        }
        if (snmp.hasSpecific()) {
            snmpInfo.setSpecific(snmp.getSpecific());
        }
        if (snmp.hasGeneric()) {
            snmpInfo.setGeneric(snmp.getGeneric());
        }
        if (snmp.getCommunity() != null) {
            snmpInfo.setCommunity(snmp.getCommunity());
        }
        return snmpInfo.build();
    }

    @Override
    public EventUpdateList toEventUpdates(List<IEvent> eventUpdates, RuntimeInfo runtimeInfo, String instanceName, boolean isSnapshot) {
        if (eventUpdates == null && runtimeInfo == null && instanceName == null) {
            return null;
        }
        EventUpdateList.Builder eventUpdateList = EventUpdateList.newBuilder();
        if (runtimeInfo != null && runtimeInfo.getSystemId() != null) {
            eventUpdateList.setInstanceId(runtimeInfo.getSystemId());
        }
        if (eventUpdates != null) {
            for (IEvent eventUpdate : eventUpdates) {
                eventUpdateList.addEvent(this.mapEvent(eventUpdate));
            }
        }
        if (instanceName != null) {
            eventUpdateList.setInstanceName(instanceName);
        }
        eventUpdateList.setSnapshot(isSnapshot);
        return eventUpdateList.build();
    }

    @Override
    public EventParameter mapEventParameter(IParm param) {
        String type;
        String content;
        if (param == null) {
            return null;
        }
        EventParameter.Builder eventParameter = EventParameter.newBuilder();
        if (param.getParmName() != null) {
            eventParameter.setName(param.getParmName());
        }
        if ((content = this.paramValueContent(param)) != null) {
            eventParameter.setValue(content);
        }
        if ((type = this.paramValueType(param)) != null) {
            eventParameter.setType(type);
        }
        return eventParameter.build();
    }

    private String eventLogmsgContent(IEvent iEvent) {
        if (iEvent == null) {
            return null;
        }
        ILogMsg logmsg = iEvent.getLogmsg();
        if (logmsg == null) {
            return null;
        }
        String content = logmsg.getContent();
        if (content == null) {
            return null;
        }
        return content;
    }

    private String eventInterfaceAddressHostAddress(IEvent iEvent) {
        if (iEvent == null) {
            return null;
        }
        InetAddress interfaceAddress = iEvent.getInterfaceAddress();
        if (interfaceAddress == null) {
            return null;
        }
        String hostAddress = interfaceAddress.getHostAddress();
        if (hostAddress == null) {
            return null;
        }
        return hostAddress;
    }

    private String paramValueContent(IParm iParm) {
        if (iParm == null) {
            return null;
        }
        IValue value = iParm.getValue();
        if (value == null) {
            return null;
        }
        String content = value.getContent();
        if (content == null) {
            return null;
        }
        return content;
    }

    private String paramValueType(IParm iParm) {
        if (iParm == null) {
            return null;
        }
        IValue value = iParm.getValue();
        if (value == null) {
            return null;
        }
        String type = value.getType();
        if (type == null) {
            return null;
        }
        return type;
    }
}

