/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.grpc.exporter.bsm;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.opennms.features.grpc.exporter.bsm.BsmInventoryService;
import org.opennms.features.grpc.exporter.mapper.MonitoredServiceWithMetadata;
import org.opennms.integration.api.v1.dao.NodeDao;
import org.opennms.integration.api.v1.model.IpInterface;
import org.opennms.integration.api.v1.model.MonitoredService;
import org.opennms.integration.api.v1.model.Node;
import org.opennms.netmgt.events.api.EventListener;
import org.opennms.netmgt.events.api.EventSubscriptionService;
import org.opennms.netmgt.events.api.model.IEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceStateExporter
implements EventListener {
    private static final Logger LOG = LoggerFactory.getLogger(ServiceStateExporter.class);
    private final EventSubscriptionService eventSubscriptionService;
    private final NodeDao nodeDao;
    private final BsmInventoryService bsmInventoryService;

    public ServiceStateExporter(EventSubscriptionService eventSubscriptionService, NodeDao nodeDao, BsmInventoryService bsmInventoryService) {
        this.eventSubscriptionService = Objects.requireNonNull(eventSubscriptionService);
        this.nodeDao = Objects.requireNonNull(nodeDao);
        this.bsmInventoryService = Objects.requireNonNull(bsmInventoryService);
    }

    public void start() {
        this.eventSubscriptionService.addEventListener((EventListener)this, List.of("uei.opennms.org/nodes/serviceResponsive", "uei.opennms.org/nodes/serviceUnresponsive", "uei.opennms.org/nodes/serviceUnmanaged", "uei.opennms.org/nodes/nodeRegainedService", "uei.opennms.org/nodes/nodeLostService", "uei.opennms.org/nodes/interfaceUp", "uei.opennms.org/nodes/interfaceDown", "uei.opennms.org/nodes/nodeUp", "uei.opennms.org/nodes/nodeDown"));
    }

    public void stop() {
        this.eventSubscriptionService.removeEventListener((EventListener)this);
    }

    public String getName() {
        return ServiceStateExporter.class.getName();
    }

    public void onEvent(IEvent event) {
        LOG.debug("Got event: {}", (Object)event);
        if (event.getNodeid() == null) {
            return;
        }
        Node node = this.nodeDao.getNodeById(Integer.valueOf(event.getNodeid().intValue()));
        if (node == null) {
            return;
        }
        Stream interfaces = event.getInterface() != null ? node.getInterfaceByIp(event.getInterfaceAddress()).stream() : node.getIpInterfaces().stream();
        List<MonitoredServiceWithMetadata> services = interfaces.flatMap(iface -> (event.getService() != null ? iface.getMonitoredService(event.getService()).stream() : iface.getMonitoredServices().stream()).map(service -> new MonitoredServiceWithMetadata(node, (IpInterface)iface, (MonitoredService)service))).collect(Collectors.toList());
        this.bsmInventoryService.sendState(services);
    }
}

