/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.enlinkd.service.api;

import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.opennms.netmgt.enlinkd.model.BridgeBridgeLink;
import org.opennms.netmgt.enlinkd.model.BridgeElement;
import org.opennms.netmgt.enlinkd.model.BridgeMacLink;
import org.opennms.netmgt.enlinkd.model.BridgeStpLink;
import org.opennms.netmgt.enlinkd.service.api.Bridge;
import org.opennms.netmgt.enlinkd.service.api.BridgeForwardingTableEntry;
import org.opennms.netmgt.enlinkd.service.api.BridgePort;
import org.opennms.netmgt.enlinkd.service.api.BroadcastDomain;
import org.opennms.netmgt.enlinkd.service.api.MacPort;
import org.opennms.netmgt.enlinkd.service.api.SharedSegment;
import org.opennms.netmgt.enlinkd.service.api.TopologyService;
import org.opennms.netmgt.enlinkd.service.api.TopologyShared;

public interface BridgeTopologyService
extends TopologyService {
    public static SharedSegment createSharedSegmentFromBridgeMacLink(BridgeMacLink link) {
        SharedSegment segment = new SharedSegment();
        segment.getBridgePortsOnSegment().add(BridgeTopologyService.getBridgePortFromBridgeMacLink(link));
        segment.getMacsOnSegment().add(link.getMacAddress());
        segment.setDesignatedBridge(link.getNode().getId());
        segment.setCreateTime(link.getBridgeMacLinkCreateTime());
        segment.setLastPollTime(link.getBridgeMacLinkLastPollTime());
        return segment;
    }

    public static SharedSegment createSharedSegmentFromBridgeBridgeLink(BridgeBridgeLink link) {
        SharedSegment segment = new SharedSegment();
        segment.getBridgePortsOnSegment().add(BridgeTopologyService.getBridgePortFromBridgeBridgeLink(link));
        segment.getBridgePortsOnSegment().add(BridgeTopologyService.getBridgePortFromDesignatedBridgeBridgeLink(link));
        segment.setDesignatedBridge(link.getDesignatedNode().getId());
        segment.setCreateTime(link.getBridgeBridgeLinkCreateTime());
        segment.setLastPollTime(link.getBridgeBridgeLinkLastPollTime());
        return segment;
    }

    public static BridgePort getBridgePortFromBridgeMacLink(BridgeMacLink link) {
        BridgePort bp = new BridgePort();
        bp.setNodeId(link.getNode().getId());
        bp.setBridgePort(link.getBridgePort());
        bp.setBridgePortIfIndex(link.getBridgePortIfIndex());
        bp.setVlan(link.getVlan());
        return bp;
    }

    public static BridgePort getBridgePortFromBridgeBridgeLink(BridgeBridgeLink link) {
        BridgePort bp = new BridgePort();
        bp.setNodeId(link.getNode().getId());
        bp.setBridgePort(link.getBridgePort());
        bp.setBridgePortIfIndex(link.getBridgePortIfIndex());
        bp.setVlan(link.getVlan());
        return bp;
    }

    public static BridgePort getBridgePortFromDesignatedBridgeBridgeLink(BridgeBridgeLink link) {
        BridgePort bp = new BridgePort();
        bp.setNodeId(link.getDesignatedNode().getId());
        bp.setBridgePort(link.getDesignatedPort());
        bp.setBridgePortIfIndex(link.getDesignatedPortIfIndex());
        bp.setVlan(link.getDesignatedVlan());
        return bp;
    }

    public Set<String> getBridgeIdentifiers(Bridge var1);

    public String getBridgeDesignatedIdentifier(Bridge var1);

    public boolean collectBft(int var1, int var2);

    public void collectedBft(int var1);

    public void load();

    public List<SharedSegment> getSharedSegments(int var1);

    public SharedSegment getSharedSegment(String var1);

    public void delete(int var1);

    public BroadcastDomain reconcile(BroadcastDomain var1, int var2);

    public void reconcile(int var1, Date var2);

    public void store(int var1, BridgeElement var2);

    public void store(int var1, BridgeStpLink var2);

    public void store(int var1, List<BridgeForwardingTableEntry> var2);

    public void store(BroadcastDomain var1, Date var2);

    public void add(BroadcastDomain var1);

    public void updateBridgeOnDomain(BroadcastDomain var1, Integer var2);

    public Set<BroadcastDomain> findAll();

    public BroadcastDomain getBroadcastDomain(int var1);

    public Map<Integer, Set<BridgeForwardingTableEntry>> getUpdateBftMap();

    public Set<BridgeForwardingTableEntry> useBridgeTopologyUpdateBFT(int var1);

    public List<TopologyShared> match();

    public List<MacPort> getMacPorts();

    public void deletePersistedData();
}

