/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.snmp;

import java.util.Arrays;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.opennms.netmgt.snmp.SnmpInstId;
import org.opennms.netmgt.snmp.SnmpInstIdXmlAdapter;
import org.opennms.netmgt.snmp.SnmpObjId;
import org.opennms.netmgt.snmp.SnmpObjIdXmlAdapter;
import org.opennms.netmgt.snmp.SnmpValue;
import org.opennms.netmgt.snmp.SnmpValueXmlAdapter;
import org.opennms.netmgt.snmp.ToStringBuilder;

@XmlRootElement(name="snmp-result")
@XmlAccessorType(value=XmlAccessType.NONE)
public class SnmpResult
implements Comparable<SnmpResult> {
    @XmlElement(name="base")
    @XmlJavaTypeAdapter(value=SnmpObjIdXmlAdapter.class)
    private SnmpObjId m_base;
    @XmlElement(name="instance")
    @XmlJavaTypeAdapter(value=SnmpInstIdXmlAdapter.class)
    private SnmpInstId m_instance;
    @XmlElement(name="value")
    @XmlJavaTypeAdapter(value=SnmpValueXmlAdapter.class)
    private SnmpValue m_value;

    protected SnmpResult() {
    }

    public SnmpResult(SnmpObjId base, SnmpInstId instance, SnmpValue value) {
        this.m_base = base;
        this.m_instance = instance;
        this.m_value = value;
    }

    public SnmpObjId getBase() {
        return this.m_base;
    }

    public void setBase(SnmpObjId base) {
        this.m_base = base;
    }

    public SnmpInstId getInstance() {
        return this.m_instance;
    }

    public void setInstance(SnmpInstId instance) {
        this.m_instance = instance;
    }

    public SnmpValue getValue() {
        return this.m_value;
    }

    public void setValue(SnmpValue value) {
        this.m_value = value;
    }

    public SnmpObjId getAbsoluteInstance() {
        return this.getBase().append(this.getInstance());
    }

    public String toString() {
        return new ToStringBuilder(this).append("base", this.getBase()).append("instance", this.getInstance()).append("value", this.getValue()).toString();
    }

    @Override
    public int compareTo(SnmpResult other) {
        return this.getAbsoluteInstance().compareTo(other.getAbsoluteInstance());
    }

    public int hashCode() {
        return Objects.hash(this.m_base, this.m_instance, this.m_value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SnmpResult other = (SnmpResult)obj;
        if (this.m_value == null ? other.m_value != null : this.m_value.getType() != other.m_value.getType() || !Arrays.equals(this.m_value.getBytes(), other.m_value.getBytes())) {
            return false;
        }
        return Objects.equals(this.m_base, other.m_base) && Objects.equals(this.m_instance, other.m_instance);
    }
}

