/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.snmp;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import org.opennms.netmgt.snmp.CollectionTracker;
import org.opennms.netmgt.snmp.ErrorStatus;
import org.opennms.netmgt.snmp.ErrorStatusException;
import org.opennms.netmgt.snmp.PduBuilder;
import org.opennms.netmgt.snmp.ResponseProcessor;
import org.opennms.netmgt.snmp.SnmpException;
import org.opennms.netmgt.snmp.SnmpInstId;
import org.opennms.netmgt.snmp.SnmpObjId;
import org.opennms.netmgt.snmp.SnmpResult;
import org.opennms.netmgt.snmp.SnmpValue;
import org.opennms.netmgt.snmp.proxy.WalkRequest;
import org.opennms.netmgt.snmp.proxy.WalkResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SingleInstanceTracker
extends CollectionTracker {
    private static final transient Logger LOG = LoggerFactory.getLogger(SingleInstanceTracker.class);
    private SnmpObjId m_base;
    private SnmpInstId m_inst;
    private SnmpObjId m_oid;
    private int m_maxRetries;
    private Integer m_retries;

    public SingleInstanceTracker(SnmpObjId base, SnmpInstId inst) {
        this(base, inst, null);
    }

    public SingleInstanceTracker(String baseOid, String instId) {
        this(SnmpObjId.get(baseOid), new SnmpInstId(instId));
    }

    public SingleInstanceTracker(SnmpObjId base, SnmpInstId inst, CollectionTracker parent) {
        super(parent);
        this.m_base = base;
        this.m_inst = inst;
        this.m_oid = SnmpObjId.get(this.m_base, this.m_inst);
    }

    @Override
    public void setMaxRepetitions(int maxRepititions) {
    }

    public int getMaxRetries() {
        return this.m_maxRetries;
    }

    @Override
    public void setMaxRetries(int maxRetries) {
        this.m_maxRetries = maxRetries;
    }

    @Override
    public ResponseProcessor buildNextPdu(PduBuilder pduBuilder) throws SnmpException {
        if (pduBuilder.getMaxVarsPerPdu() < 1) {
            throw new SnmpException("maxVarsPerPdu < 1");
        }
        SnmpObjId requestOid = this.m_oid.decrement();
        LOG.debug("Requesting oid following: {}", (Object)requestOid);
        pduBuilder.addOid(requestOid);
        pduBuilder.setNonRepeaters(1);
        pduBuilder.setMaxRepetitions(1);
        ResponseProcessor rp = new ResponseProcessor(){

            @Override
            public void processResponse(SnmpObjId responseObjId, SnmpValue val) {
                LOG.debug("Processing varBind: {} = {}", (Object)responseObjId, (Object)val);
                if (val.isEndOfMib()) {
                    SingleInstanceTracker.this.receivedEndOfMib();
                }
                if (SingleInstanceTracker.this.m_oid.equals(responseObjId)) {
                    SingleInstanceTracker.this.storeResult(new SnmpResult(SingleInstanceTracker.this.m_base, SingleInstanceTracker.this.m_inst, val));
                }
                SingleInstanceTracker.this.setFinished(true);
            }

            @Override
            public boolean processErrors(int errorStatus, int errorIndex) throws SnmpException {
                ErrorStatus status;
                if (SingleInstanceTracker.this.m_retries == null) {
                    SingleInstanceTracker.this.m_retries = SingleInstanceTracker.this.getMaxRetries();
                }
                if ((status = ErrorStatus.fromStatus(errorStatus)) == ErrorStatus.TOO_BIG) {
                    throw new SnmpException("Unable to handle tooBigError for oid request " + String.valueOf(SingleInstanceTracker.this.m_oid.decrement()));
                }
                if (status == ErrorStatus.GEN_ERR) {
                    SingleInstanceTracker.this.reportGenErr("Received genErr requesting oid " + String.valueOf(SingleInstanceTracker.this.m_oid.decrement()) + ". Marking column as finished.");
                    SingleInstanceTracker.this.errorOccurred();
                    return true;
                }
                if (status == ErrorStatus.NO_SUCH_NAME) {
                    SingleInstanceTracker.this.reportNoSuchNameErr("Received noSuchName requesting oid " + String.valueOf(SingleInstanceTracker.this.m_oid.decrement()) + ". Marking column as finished.");
                    SingleInstanceTracker.this.errorOccurred();
                    return true;
                }
                if (status.isFatal()) {
                    ErrorStatusException ex = new ErrorStatusException(status, "Unexpected error processing oid " + String.valueOf(SingleInstanceTracker.this.m_oid.decrement()) + ". Marking column as finished!");
                    LOG.debug("Fatal Error: {}", (Object)status, (Object)ex);
                    throw ex;
                }
                if (status != ErrorStatus.NO_ERROR) {
                    LOG.warn("Non-fatal error encountered: {}. {}", (Object)status, (Object)(status.retry() ? "Retrying." : "Giving up."));
                }
                if (status.retry()) {
                    Serializable ex = SingleInstanceTracker.this.m_retries;
                    SingleInstanceTracker.this.m_retries = SingleInstanceTracker.this.m_retries - 1;
                    if (ex <= 0) {
                        ex = new ErrorStatusException(status, "Non-fatal error met maximum number of retries. Aborting!");
                        SingleInstanceTracker.this.reportFatalErr((ErrorStatusException)ex);
                        throw ex;
                    }
                } else {
                    SingleInstanceTracker.this.m_retries = SingleInstanceTracker.this.getMaxRetries();
                }
                return status.retry();
            }
        };
        return rp;
    }

    protected void errorOccurred() {
        this.setFinished(true);
    }

    protected void receivedEndOfMib() {
        this.setFinished(true);
    }

    @Override
    public List<WalkRequest> getWalkRequests() {
        WalkRequest walkRequest = new WalkRequest(this.m_base);
        walkRequest.setInstance(this.m_inst);
        walkRequest.setMaxRepetitions(1);
        return Collections.singletonList(walkRequest);
    }

    @Override
    public void handleWalkResponses(List<WalkResponse> responses) {
        responses.stream().flatMap(res -> res.getResults().stream()).filter(res -> this.m_oid.equals(SnmpObjId.get(res.getBase(), res.getInstance()))).forEach(this::storeResult);
        this.setFinished(true);
    }
}

