/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.config.osgi.cm;

import java.util.Objects;
import org.opennms.features.config.exception.ConfigRuntimeException;
import org.opennms.features.config.osgi.del.MigratedServices;
import org.opennms.features.config.service.api.ConfigUpdateInfo;
import org.opennms.features.config.service.util.Substring;

public class CmIdentifierUtil {
    public static ConfigUpdateInfo pidToCmIdentifier(String pid) {
        String configId;
        String configName;
        Objects.requireNonNull(pid);
        if (MigratedServices.PIDS_SINGLE_INSTANCE.contains(pid)) {
            configName = pid;
            configId = "default";
        } else {
            configName = MigratedServices.PIDS_MULTI_INSTANCE.stream().filter(pid::startsWith).findAny().orElseThrow(() -> new ConfigRuntimeException(String.format("Pid=%s could not be parsed into ConfigUpdateInfo", pid)));
            configId = new Substring(pid).getAfterLast(configName + "-").toString();
        }
        return new ConfigUpdateInfo(configName, configId);
    }

    public static String cmIdentifierToPid(ConfigUpdateInfo identifier) {
        Objects.requireNonNull(identifier);
        StringBuilder b = new StringBuilder(identifier.getConfigName());
        if (!"default".equals(identifier.getConfigId())) {
            b.append("-").append(identifier.getConfigId());
        }
        return b.toString();
    }
}

