/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.flows.rest.internal.classification;

import java.util.Map;
import javax.ws.rs.core.Response;
import org.opennms.netmgt.flows.classification.csv.CsvImportResult;
import org.opennms.netmgt.flows.classification.error.Error;
import org.opennms.netmgt.flows.rest.classification.CsvImportErrorDTO;
import org.opennms.netmgt.flows.rest.classification.ErrorDTO;

public class ErrorResponseUtils {
    public static Response createResponse(Error error) {
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)ErrorResponseUtils.convert(error)).build();
    }

    public static Response createResponse(CsvImportResult csvImportResult) {
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)ErrorResponseUtils.convert(csvImportResult)).build();
    }

    private static CsvImportErrorDTO convert(CsvImportResult importResult) {
        CsvImportErrorDTO errorDTO = new CsvImportErrorDTO();
        errorDTO.setSuccess(importResult.isSuccess());
        if (importResult.getError() != null) {
            errorDTO.setError(ErrorResponseUtils.convert(importResult.getError()));
        }
        for (Map.Entry entry : importResult.getErrorMap().entrySet()) {
            errorDTO.addError((Long)entry.getKey(), ErrorResponseUtils.convert((Error)entry.getValue()));
        }
        return errorDTO;
    }

    private static ErrorDTO convert(Error error) {
        ErrorDTO errorDTO = new ErrorDTO();
        errorDTO.setKey(error.getTemplate().getKey());
        errorDTO.setContext(error.getContext());
        errorDTO.setMessage(error.getFormattedMessage());
        return errorDTO;
    }
}

