/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.enlinkd.snmp;

import java.net.InetAddress;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.enlinkd.model.OspfIf;
import org.opennms.netmgt.snmp.RowCallback;
import org.opennms.netmgt.snmp.SnmpInstId;
import org.opennms.netmgt.snmp.SnmpObjId;
import org.opennms.netmgt.snmp.SnmpRowResult;
import org.opennms.netmgt.snmp.TableTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OspfIfTableTracker
extends TableTracker {
    private static final Logger LOG = LoggerFactory.getLogger(OspfIfTableTracker.class);
    public static final SnmpObjId OSPF_IF_IPADDRESS_OID = SnmpObjId.get((String)".1.3.6.1.2.1.14.7.1.1");
    public static final SnmpObjId OSPF_ADDRESS_LESS_IF_OID = SnmpObjId.get((String)".1.3.6.1.2.1.14.7.1.2");
    public static final SnmpObjId OSPF_IF_AREA_ID_OID = SnmpObjId.get((String)".1.3.6.1.2.1.14.7.1.3");
    public static final String OSPF_IF_IPADDRESS = "ospfIfIpAddress";
    public static final String OSPF_ADDRESS_LESS_IF = "ospfAddressLessIf";
    public static final String OSPF_IF_AREA_ID = "ospfIfAreaId";
    public static final SnmpObjId[] s_ospfiftable_elemList = new SnmpObjId[]{OSPF_IF_IPADDRESS_OID, OSPF_ADDRESS_LESS_IF_OID, OSPF_IF_AREA_ID_OID};

    public OspfIfTableTracker() {
        super(s_ospfiftable_elemList);
    }

    public OspfIfTableTracker(RowCallback rowProcessor) {
        super(rowProcessor, s_ospfiftable_elemList);
    }

    public SnmpRowResult createRowResult(int columnCount, SnmpInstId instance) {
        return new OspfIfRow(columnCount, instance);
    }

    public void rowCompleted(SnmpRowResult row) {
        this.processOspfIfRow((OspfIfRow)row);
    }

    public void processOspfIfRow(OspfIfRow row) {
        System.out.printf("\t\t%s (%s)= %s \n", String.valueOf(OSPF_IF_IPADDRESS_OID) + "." + row.getInstance().toString(), OSPF_IF_IPADDRESS, InetAddressUtils.str((InetAddress)row.getOspfIpAddress()));
        System.out.printf("\t\t%s (%s)= %s \n", String.valueOf(OSPF_ADDRESS_LESS_IF_OID) + "." + row.getInstance().toString(), OSPF_ADDRESS_LESS_IF, row.getOspfAddressLessIf());
        System.out.printf("\t\t%s (%s)= %s \n", String.valueOf(OSPF_IF_AREA_ID_OID) + "." + row.getInstance().toString(), OSPF_IF_AREA_ID, InetAddressUtils.str((InetAddress)row.getOspfIfAreaId()));
    }

    public static class OspfIfRow
    extends SnmpRowResult {
        public OspfIfRow(int columnCount, SnmpInstId instance) {
            super(columnCount, instance);
            LOG.debug("column count = {}, instance = {}", (Object)columnCount, (Object)instance);
        }

        public InetAddress getOspfIpAddress() {
            return this.getValue(OSPF_IF_IPADDRESS_OID).toInetAddress();
        }

        public Integer getOspfAddressLessIf() {
            return this.getValue(OSPF_ADDRESS_LESS_IF_OID).toInt();
        }

        public InetAddress getOspfIfAreaId() {
            return this.getValue(OSPF_IF_AREA_ID_OID).toInetAddress();
        }

        public OspfIf getOspfIf() {
            LOG.debug("getOspfIf: ospf ip address: {}, address less ifindex {}, area id {}", new Object[]{InetAddressUtils.str((InetAddress)this.getOspfIpAddress()), this.getOspfAddressLessIf(), InetAddressUtils.str((InetAddress)this.getOspfIfAreaId())});
            OspfIf ospfIf = new OspfIf();
            ospfIf.setOspfIfIpaddress(this.getOspfIpAddress());
            ospfIf.setOspfIfAddressLessIf(this.getOspfAddressLessIf());
            ospfIf.setOspfIfAreaId(this.getOspfIfAreaId());
            return ospfIf;
        }
    }
}

