/*
 * Decompiled with CFR 0.152.
 */
package org.jinterop.dcom.core;

import java.io.IOException;
import java.util.List;
import java.util.Properties;
import java.util.logging.Logger;
import org.jinterop.dcom.core.JIObjectId;
import org.jinterop.dcom.core.PingObject;
import org.jinterop.dcom.transport.JIComTransportFactory;
import rpc.Stub;
import rpc.TransportFactory;

final class JIComOxidStub
extends Stub {
    private static final Logger LOGGER = Logger.getLogger("org.jinterop");
    private static final Properties DEFAULTS = new Properties();

    JIComOxidStub(String address, String domain, String username, String password) {
        super.setTransportFactory((TransportFactory)JIComTransportFactory.getSingleTon());
        super.setProperties(new Properties(DEFAULTS));
        super.getProperties().setProperty("rpc.security.username", username);
        super.getProperties().setProperty("rpc.security.password", password);
        super.getProperties().setProperty("rpc.ntlm.domain", domain);
        super.setAddress("ncacn_ip_tcp:" + address + "[135]");
    }

    public byte[] call(boolean isSimplePing, byte[] setId, List<JIObjectId> listOfAdds, List<JIObjectId> listOfDels, int seqNum) {
        PingObject pingObject = new PingObject();
        pingObject.setId = setId;
        pingObject.listOfAdds = listOfAdds;
        pingObject.listOfDels = listOfDels;
        pingObject.seqNum = seqNum;
        pingObject.opnum = isSimplePing ? 1 : 2;
        try {
            this.call(2, pingObject);
        }
        catch (IOException e) {
            LOGGER.throwing("JIComOxidStub", "call", e);
        }
        return pingObject.setId;
    }

    public void close() {
        try {
            this.detach();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected String getSyntax() {
        return "99fcfec4-5260-101b-bbcb-00aa0021347a:0.0";
    }

    static {
        DEFAULTS.put("rpc.ntlm.lanManagerKey", "false");
        DEFAULTS.put("rpc.ntlm.sign", "false");
        DEFAULTS.put("rpc.ntlm.seal", "false");
        DEFAULTS.put("rpc.ntlm.keyExchange", "false");
        DEFAULTS.put("rpc.connectionContext", "rpc.security.ntlm.NtlmConnectionContext");
    }
}

