/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.jaas.jasypt.impl;

import java.util.Map;
import org.apache.karaf.jaas.modules.Encryption;
import org.jasypt.digest.config.DigesterConfig;
import org.jasypt.digest.config.SimpleStringDigesterConfig;
import org.jasypt.exceptions.EncryptionInitializationException;
import org.jasypt.util.password.ConfigurablePasswordEncryptor;

public class JasyptEncryption
implements Encryption {
    private ConfigurablePasswordEncryptor passwordEncryptor;

    public JasyptEncryption(Map<String, String> params) {
        SimpleStringDigesterConfig config = new SimpleStringDigesterConfig();
        for (String key : params.keySet()) {
            if ("algorithm".equalsIgnoreCase(key)) {
                config.setAlgorithm(params.get(key));
                continue;
            }
            if ("encoding".equalsIgnoreCase(key)) {
                config.setStringOutputType(params.get(key));
                continue;
            }
            if ("providerName".equalsIgnoreCase(key)) {
                config.setProviderName(params.get(key));
                continue;
            }
            if ("saltSizeBytes".equalsIgnoreCase(key)) {
                config.setSaltSizeBytes(params.get(key));
                continue;
            }
            if ("iterations".equalsIgnoreCase(key)) {
                config.setIterations(params.get(key));
                continue;
            }
            if ("providerClassName".equalsIgnoreCase(key)) {
                config.setProviderClassName(params.get(key));
                continue;
            }
            if ("saltGeneratorClassName".equalsIgnoreCase(key)) {
                config.setSaltGeneratorClassName(params.get(key));
                continue;
            }
            throw new IllegalArgumentException("Unsupported encryption parameter: " + key);
        }
        this.passwordEncryptor = new ConfigurablePasswordEncryptor();
        this.passwordEncryptor.setConfig((DigesterConfig)config);
        try {
            this.passwordEncryptor.encryptPassword("test");
        }
        catch (EncryptionInitializationException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public String encryptPassword(String plain) {
        return this.passwordEncryptor.encryptPassword(plain);
    }

    public boolean checkPassword(String input, String password) {
        return this.passwordEncryptor.checkPassword(input, password);
    }
}

