/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.visualization.picking;

import edu.uci.ics.jung.algorithms.layout.GraphElementAccessor;
import edu.uci.ics.jung.algorithms.layout.Layout;
import edu.uci.ics.jung.graph.util.Pair;
import edu.uci.ics.jung.visualization.Layer;
import edu.uci.ics.jung.visualization.VisualizationServer;
import edu.uci.ics.jung.visualization.picking.ShapePickSupport;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.HashSet;

public class LayoutLensShapePickSupport<V, E>
extends ShapePickSupport<V, E>
implements GraphElementAccessor<V, E> {
    public LayoutLensShapePickSupport(VisualizationServer<V, E> vv, float pickSize) {
        super(vv, pickSize);
    }

    public LayoutLensShapePickSupport(VisualizationServer<V, E> vv) {
        this(vv, 2.0f);
    }

    @Override
    public V getVertex(Layout<V, E> layout, double x, double y) {
        V closest = null;
        double minDistance = Double.MAX_VALUE;
        while (true) {
            try {
                for (V v : this.getFilteredVertices(layout)) {
                    double dy;
                    AffineTransform xform;
                    Shape shape = (Shape)this.vv.getRenderContext().getVertexShapeTransformer().apply(v);
                    Point2D p = (Point2D)layout.apply(v);
                    if (p == null || !(shape = (xform = AffineTransform.getTranslateInstance((p = this.vv.getRenderContext().getMultiLayerTransformer().transform(p)).getX(), p.getY())).createTransformedShape(shape)).contains(x, y)) continue;
                    if (this.style == ShapePickSupport.Style.LOWEST) {
                        return v;
                    }
                    if (this.style == ShapePickSupport.Style.HIGHEST) {
                        closest = v;
                        continue;
                    }
                    Rectangle2D bounds = shape.getBounds2D();
                    double dx = bounds.getCenterX() - x;
                    double dist = dx * dx + (dy = bounds.getCenterY() - y) * dy;
                    if (!(dist < minDistance)) continue;
                    minDistance = dist;
                    closest = v;
                }
            }
            catch (ConcurrentModificationException concurrentModificationException) {
                continue;
            }
            break;
        }
        return closest;
    }

    @Override
    public Collection<V> getVertices(Layout<V, E> layout, Shape rectangle) {
        HashSet<V> pickedVertices = new HashSet<V>();
        while (true) {
            try {
                for (V v : this.getFilteredVertices(layout)) {
                    Point2D p = (Point2D)layout.apply(v);
                    if (p == null || !rectangle.contains(p = this.vv.getRenderContext().getMultiLayerTransformer().transform(p))) continue;
                    pickedVertices.add(v);
                }
            }
            catch (ConcurrentModificationException concurrentModificationException) {
                continue;
            }
            break;
        }
        return pickedVertices;
    }

    @Override
    public E getEdge(Layout<V, E> layout, double x, double y) {
        Point2D ip = this.vv.getRenderContext().getMultiLayerTransformer().inverseTransform(Layer.VIEW, new Point2D.Double(x, y));
        x = ip.getX();
        y = ip.getY();
        Rectangle2D.Float pickArea = new Rectangle2D.Float((float)x - this.pickSize / 2.0f, (float)y - this.pickSize / 2.0f, this.pickSize, this.pickSize);
        E closest = null;
        double minDistance = Double.MAX_VALUE;
        while (true) {
            try {
                for (E e : this.getFilteredEdges(layout)) {
                    float dy;
                    float dx;
                    float dist;
                    Pair<V> pair = layout.getGraph().getEndpoints(e);
                    V v1 = pair.getFirst();
                    V v2 = pair.getSecond();
                    boolean isLoop = v1.equals(v2);
                    Point2D p1 = this.vv.getRenderContext().getMultiLayerTransformer().transform(Layer.LAYOUT, (Point2D)layout.apply(v1));
                    Point2D p2 = this.vv.getRenderContext().getMultiLayerTransformer().transform(Layer.LAYOUT, (Point2D)layout.apply(v2));
                    if (p1 == null || p2 == null) continue;
                    float x1 = (float)p1.getX();
                    float y1 = (float)p1.getY();
                    float x2 = (float)p2.getX();
                    float y2 = (float)p2.getY();
                    AffineTransform xform = AffineTransform.getTranslateInstance(x1, y1);
                    Shape edgeShape = (Shape)this.vv.getRenderContext().getEdgeShapeTransformer().apply(e);
                    if (isLoop) {
                        Shape s2 = (Shape)this.vv.getRenderContext().getVertexShapeTransformer().apply(v2);
                        Rectangle2D s2Bounds = s2.getBounds2D();
                        xform.scale(s2Bounds.getWidth(), s2Bounds.getHeight());
                        xform.translate(0.0, -edgeShape.getBounds2D().getHeight() / 2.0);
                    } else {
                        float dx2 = x2 - x1;
                        float dy2 = y2 - y1;
                        double theta = Math.atan2(dy2, dx2);
                        xform.rotate(theta);
                        float dist2 = (float)Math.sqrt(dx2 * dx2 + dy2 * dy2);
                        xform.scale(dist2, 1.0);
                    }
                    if (!(edgeShape = xform.createTransformedShape(edgeShape)).intersects(pickArea)) continue;
                    float cx = 0.0f;
                    float cy = 0.0f;
                    float[] f = new float[6];
                    PathIterator pi = new GeneralPath(edgeShape).getPathIterator(null);
                    if (!pi.isDone()) {
                        pi.next();
                        pi.currentSegment(f);
                        cx = f[0];
                        cy = f[1];
                        if (!pi.isDone()) {
                            pi.currentSegment(f);
                            cx = f[0];
                            cy = f[1];
                        }
                    }
                    if (!((double)(dist = (dx = (float)((double)cx - x)) * dx + (dy = (float)((double)cy - y)) * dy) < minDistance)) continue;
                    minDistance = dist;
                    closest = e;
                }
            }
            catch (ConcurrentModificationException concurrentModificationException) {
                continue;
            }
            break;
        }
        return closest;
    }
}

