/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.config.rest.api;

import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;

@Path(value="/cm")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public interface ConfigManagerRestService {
    @GET
    @Produces(value={"application/json"})
    public Response listConfigs();

    @GET
    @Path(value="/schema")
    public Response getAllOpenApiSchema(@HeaderParam(value="accept") String var1, @Context HttpServletRequest var2);

    @GET
    @Path(value="/schema/{configName}")
    public Response getOpenApiSchema(@PathParam(value="configName") String var1, @HeaderParam(value="accept") String var2, @Context HttpServletRequest var3);

    @GET
    @Path(value="/{configName}")
    public Response getConfigIds(@PathParam(value="configName") String var1);

    @GET
    @Path(value="/{configName}/{configId}")
    public Response getConfig(@PathParam(value="configName") String var1, @PathParam(value="configId") String var2);

    @POST
    @Path(value="/{configName}/{configId}")
    public Response addConfig(@PathParam(value="configName") String var1, @PathParam(value="configId") String var2, String var3);

    @PUT
    @Path(value="/{configName}/{configId}")
    public Response updateConfig(@PathParam(value="configName") String var1, @PathParam(value="configId") String var2, @QueryParam(value="replace") boolean var3, String var4);

    @DELETE
    @Path(value="/{configName}/{configId}")
    public Response deleteConfig(@PathParam(value="configName") String var1, @PathParam(value="configId") String var2);

    @GET
    @Path(value="/{configName}/{configId}/{path}")
    public Response getConfigPart(@PathParam(value="configName") String var1, @PathParam(value="configId") String var2, @PathParam(value="path") String var3);

    @PUT
    @Path(value="/{configName}/{configId}/{path}")
    public Response updateConfigPart(@PathParam(value="configName") String var1, @PathParam(value="configId") String var2, @PathParam(value="path") String var3, String var4);

    @PUT
    @Path(value="/{configName}/{configId}/{pathToParent}/{nodeName}")
    public Response updateOrInsertConfigPart(@PathParam(value="configName") String var1, @PathParam(value="configId") String var2, @PathParam(value="pathToParent") String var3, @PathParam(value="nodeName") String var4, String var5);

    @POST
    @Path(value="/{configName}/{configId}/{path}")
    public Response appendToArrayInConfig(@PathParam(value="configName") String var1, @PathParam(value="configId") String var2, @PathParam(value="path") String var3, String var4);

    @DELETE
    @Path(value="/{configName}/{configId}/{path}")
    public Response deleteConfigPart(@PathParam(value="configName") String var1, @PathParam(value="configId") String var2, @PathParam(value="path") String var3);
}

