/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.client;

import java.io.IOException;
import java.net.ConnectException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.HttpClient;
import org.apache.http.conn.ConnectTimeoutException;
import org.jolokia.client.J4pClientBuilder;
import org.jolokia.client.J4pClientBuilderFactory;
import org.jolokia.client.exception.J4pBulkRemoteException;
import org.jolokia.client.exception.J4pConnectException;
import org.jolokia.client.exception.J4pException;
import org.jolokia.client.exception.J4pRemoteException;
import org.jolokia.client.exception.J4pTimeoutException;
import org.jolokia.client.request.J4pQueryParameter;
import org.jolokia.client.request.J4pRequest;
import org.jolokia.client.request.J4pRequestHandler;
import org.jolokia.client.request.J4pResponse;
import org.jolokia.client.request.J4pResponseExtractor;
import org.jolokia.client.request.J4pTargetConfig;
import org.jolokia.client.request.ValidatingResponseExtractor;
import org.json.simple.JSONArray;
import org.json.simple.JSONAware;
import org.json.simple.JSONObject;
import org.json.simple.parser.ParseException;

public class J4pClient
extends J4pClientBuilderFactory {
    private HttpClient httpClient;
    private J4pRequestHandler requestHandler;
    private J4pResponseExtractor responseExtractor;

    public J4pClient(String pJ4pServerUrl) {
        this(pJ4pServerUrl, null);
    }

    public J4pClient(String pJ4pServerUrl, HttpClient pHttpClient) {
        this(pJ4pServerUrl, pHttpClient, null);
    }

    public J4pClient(String pJ4pServerUrl, HttpClient pHttpClient, J4pTargetConfig pTargetConfig) {
        this(pJ4pServerUrl, pHttpClient, pTargetConfig, ValidatingResponseExtractor.DEFAULT);
    }

    public J4pClient(String pJ4pServerUrl, HttpClient pHttpClient, J4pTargetConfig pTargetConfig, J4pResponseExtractor pExtractor) {
        this.requestHandler = new J4pRequestHandler(pJ4pServerUrl, pTargetConfig);
        this.responseExtractor = pExtractor;
        if (pHttpClient != null) {
            this.httpClient = pHttpClient;
        } else {
            J4pClientBuilder builder = new J4pClientBuilder();
            this.httpClient = builder.createHttpClient();
        }
    }

    public <RESP extends J4pResponse<REQ>, REQ extends J4pRequest> RESP execute(REQ pRequest) throws J4pException {
        return this.execute(pRequest, null, null);
    }

    public <RESP extends J4pResponse<REQ>, REQ extends J4pRequest> RESP execute(REQ pRequest, Map<J4pQueryParameter, String> pProcessingOptions) throws J4pException {
        return this.execute(pRequest, null, pProcessingOptions);
    }

    public <RESP extends J4pResponse<REQ>, REQ extends J4pRequest> RESP execute(REQ pRequest, String pMethod) throws J4pException {
        return this.execute(pRequest, pMethod, null);
    }

    public <RESP extends J4pResponse<REQ>, REQ extends J4pRequest> RESP execute(REQ pRequest, String pMethod, Map<J4pQueryParameter, String> pProcessingOptions) throws J4pException {
        return this.execute(pRequest, pMethod, pProcessingOptions, this.responseExtractor);
    }

    public <RESP extends J4pResponse<REQ>, REQ extends J4pRequest> RESP execute(REQ pRequest, String pMethod, Map<J4pQueryParameter, String> pProcessingOptions, J4pResponseExtractor pExtractor) throws J4pException {
        try {
            HttpResponse response = this.httpClient.execute(this.requestHandler.getHttpRequest(pRequest, pMethod, pProcessingOptions));
            JSONAware jsonResponse = this.extractJsonResponse(pRequest, response);
            if (!(jsonResponse instanceof JSONObject)) {
                throw new J4pException("Invalid JSON answer for a single request (expected a map but got a " + jsonResponse.getClass() + ")");
            }
            return pExtractor.extract(pRequest, (JSONObject)jsonResponse);
        }
        catch (IOException e) {
            throw this.mapException(e);
        }
        catch (URISyntaxException e) {
            throw this.mapException(e);
        }
    }

    public <RESP extends J4pResponse<REQ>, REQ extends J4pRequest> List<RESP> execute(List<REQ> pRequests) throws J4pException {
        return this.execute(pRequests, null);
    }

    public <RESP extends J4pResponse<REQ>, REQ extends J4pRequest> List<RESP> execute(List<REQ> pRequests, Map<J4pQueryParameter, String> pProcessingOptions) throws J4pException {
        return this.execute(pRequests, pProcessingOptions, this.responseExtractor);
    }

    public <RESP extends J4pResponse<REQ>, REQ extends J4pRequest> List<RESP> execute(List<REQ> pRequests, Map<J4pQueryParameter, String> pProcessingOptions, J4pResponseExtractor pResponseExtractor) throws J4pException {
        try {
            HttpResponse response = this.httpClient.execute(this.requestHandler.getHttpRequest(pRequests, pProcessingOptions));
            JSONAware jsonResponse = this.extractJsonResponse(null, response);
            this.verifyBulkJsonResponse(jsonResponse);
            return this.extractResponses(jsonResponse, pRequests, pResponseExtractor);
        }
        catch (IOException e) {
            throw this.mapException(e);
        }
        catch (URISyntaxException e) {
            throw this.mapException(e);
        }
    }

    private <REQ extends J4pRequest> JSONAware extractJsonResponse(REQ pRequest, HttpResponse pResponse) throws J4pException {
        try {
            return this.requestHandler.extractJsonResponse(pResponse);
        }
        catch (IOException e) {
            throw new J4pException("IO-Error while reading the response: " + e, e);
        }
        catch (ParseException e) {
            StatusLine statusLine = pResponse.getStatusLine();
            if (200 != statusLine.getStatusCode()) {
                throw new J4pRemoteException(pRequest, statusLine.getReasonPhrase(), null, statusLine.getStatusCode(), null, null);
            }
            throw new J4pException("Could not parse answer: " + (Object)((Object)e), e);
        }
    }

    private <R extends J4pResponse<T>, T extends J4pRequest> List<R> extractResponses(JSONAware pJsonResponse, List<T> pRequests, J4pResponseExtractor pResponseExtractor) throws J4pException {
        JSONArray responseArray = (JSONArray)pJsonResponse;
        ArrayList ret = new ArrayList(responseArray.size());
        J4pRemoteException[] remoteExceptions = new J4pRemoteException[responseArray.size()];
        boolean exceptionFound = false;
        for (int i = 0; i < pRequests.size(); ++i) {
            J4pRequest request = (J4pRequest)pRequests.get(i);
            Object jsonResp = responseArray.get(i);
            if (!(jsonResp instanceof JSONObject)) {
                throw new J4pException("Response for request Nr. " + i + " is invalid (expected a map but got " + jsonResp.getClass() + ")");
            }
            try {
                ret.add(i, pResponseExtractor.extract(request, (JSONObject)jsonResp));
                continue;
            }
            catch (J4pRemoteException exp) {
                remoteExceptions[i] = exp;
                exceptionFound = true;
                ret.add(i, null);
            }
        }
        if (exceptionFound) {
            ArrayList<J4pRemoteException> partialResults = new ArrayList<J4pRemoteException>();
            for (int i = 0; i < pRequests.size(); ++i) {
                J4pRemoteException exp = remoteExceptions[i];
                if (exp != null) {
                    partialResults.add(exp);
                    continue;
                }
                partialResults.add((J4pRemoteException)ret.get(i));
            }
            throw new J4pBulkRemoteException(partialResults);
        }
        return ret;
    }

    private J4pException mapException(Exception pException) throws J4pException {
        if (pException instanceof ConnectException) {
            return new J4pConnectException("Cannot connect to " + this.requestHandler.getJ4pServerUrl() + ": " + pException.getMessage(), (ConnectException)pException);
        }
        if (pException instanceof ConnectTimeoutException) {
            return new J4pTimeoutException("Read timeout while request " + this.requestHandler.getJ4pServerUrl() + ": " + pException.getMessage(), (ConnectTimeoutException)pException);
        }
        if (pException instanceof IOException) {
            return new J4pException("IO-Error while contacting the server: " + pException, pException);
        }
        if (pException instanceof URISyntaxException) {
            URISyntaxException sExp = (URISyntaxException)pException;
            return new J4pException("Invalid URI " + sExp.getInput() + ": " + sExp.getReason(), pException);
        }
        return new J4pException("Exception " + pException, pException);
    }

    private void verifyBulkJsonResponse(JSONAware pJsonResponse) throws J4pException {
        if (!(pJsonResponse instanceof JSONArray)) {
            JSONObject errorObject;
            if (pJsonResponse instanceof JSONObject && (!(errorObject = (JSONObject)pJsonResponse).containsKey((Object)"status") || (Long)errorObject.get((Object)"status") != 200L)) {
                throw new J4pRemoteException(null, errorObject);
            }
            throw new J4pException("Invalid JSON answer for a bulk request (expected an array but got a " + pJsonResponse.getClass() + ")");
        }
    }

    public <R extends J4pResponse<T>, T extends J4pRequest> List<R> execute(T ... pRequests) throws J4pException {
        return this.execute(Arrays.asList(pRequests));
    }

    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    public URI getUri() {
        return this.requestHandler.getJ4pServerUrl();
    }
}

