/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.snmp;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.opennms.netmgt.snmp.Collectable;
import org.opennms.netmgt.snmp.CollectionTracker;
import org.opennms.netmgt.snmp.ErrorStatus;
import org.opennms.netmgt.snmp.ErrorStatusException;
import org.opennms.netmgt.snmp.PduBuilder;
import org.opennms.netmgt.snmp.ResponseProcessor;
import org.opennms.netmgt.snmp.SnmpException;
import org.opennms.netmgt.snmp.SnmpObjId;
import org.opennms.netmgt.snmp.SnmpValue;
import org.opennms.netmgt.snmp.proxy.CorrelationIdUtils;
import org.opennms.netmgt.snmp.proxy.WalkRequest;
import org.opennms.netmgt.snmp.proxy.WalkResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AggregateTracker
extends CollectionTracker {
    private static final Logger LOG = LoggerFactory.getLogger(AggregateTracker.class);
    private final CollectionTracker[] m_children;

    public AggregateTracker(Collection<Collectable> children) {
        this(children, null);
    }

    public AggregateTracker(Collection<Collectable> children, CollectionTracker parent) {
        this(children.toArray(new Collectable[children.size()]), parent);
    }

    public AggregateTracker(Collectable[] children) {
        this(children, null);
    }

    public AggregateTracker(Collectable[] children, CollectionTracker parent) {
        super(parent);
        this.m_children = new CollectionTracker[children.length];
        for (int i = 0; i < this.m_children.length; ++i) {
            this.m_children[i] = children[i].getCollectionTracker();
            this.m_children[i].setParent(this);
        }
    }

    @Override
    public void setFailed(boolean failed) {
        super.setFailed(failed);
        for (CollectionTracker child : this.m_children) {
            child.setFailed(failed);
        }
    }

    @Override
    public void setTimedOut(boolean timedOut) {
        super.setTimedOut(timedOut);
        for (CollectionTracker child : this.m_children) {
            child.setTimedOut(timedOut);
        }
    }

    @Override
    public void setMaxRepetitions(int maxRepititions) {
        for (CollectionTracker child : this.m_children) {
            child.setMaxRepetitions(maxRepititions);
        }
    }

    @Override
    public void setMaxRetries(int maxRetries) {
        for (CollectionTracker child : this.m_children) {
            child.setMaxRetries(maxRetries);
        }
    }

    @Override
    public boolean isFinished() {
        for (CollectionTracker child : this.m_children) {
            if (child.isFinished()) continue;
            return false;
        }
        return true;
    }

    @Override
    public ResponseProcessor buildNextPdu(PduBuilder parentBuilder) throws SnmpException {
        int count = 0;
        int maxVars = parentBuilder.getMaxVarsPerPdu();
        ArrayList<ChildTrackerPduBuilder> builders = new ArrayList<ChildTrackerPduBuilder>(this.m_children.length);
        for (int i = 0; i < this.m_children.length && count < maxVars; ++i) {
            CollectionTracker childTracker = this.m_children[i];
            if (childTracker.isFinished()) continue;
            ChildTrackerPduBuilder childBuilder = new ChildTrackerPduBuilder(maxVars - count);
            ResponseProcessor rp = childTracker.buildNextPdu(childBuilder);
            childBuilder.setResponseProcessor(rp);
            builders.add(childBuilder);
            count += childBuilder.size();
        }
        int nonRepeaters = 0;
        for (ChildTrackerPduBuilder childBuilder : builders) {
            childBuilder.setNonRepeaterStartIndex(nonRepeaters);
            childBuilder.addNonRepeaters(parentBuilder);
            nonRepeaters += childBuilder.getNonRepeaters();
        }
        int maxRepititions = Integer.MAX_VALUE;
        int repeaters = 0;
        for (ChildTrackerPduBuilder childBuilder : builders) {
            childBuilder.setRepeaterStartIndex(nonRepeaters + repeaters);
            childBuilder.addRepeaters(parentBuilder);
            maxRepititions = Math.min(maxRepititions, childBuilder.getMaxRepititions());
            repeaters += childBuilder.getRepeaters();
        }
        parentBuilder.setNonRepeaters(nonRepeaters);
        parentBuilder.setMaxRepetitions(maxRepititions == Integer.MAX_VALUE ? 1 : maxRepititions);
        return new ChildTrackerResponseProcessor(this, parentBuilder, builders, nonRepeaters, repeaters);
    }

    @Override
    public List<WalkRequest> getWalkRequests() {
        ArrayList<WalkRequest> walkRequests = new ArrayList<WalkRequest>();
        for (int k = 0; k < this.m_children.length; ++k) {
            for (WalkRequest walkRequest : this.m_children[k].getWalkRequests()) {
                CorrelationIdUtils.pushIndexToCorrelationId(walkRequest, k);
                walkRequests.add(walkRequest);
            }
        }
        return walkRequests;
    }

    @Override
    public void handleWalkResponses(List<WalkResponse> responses) {
        HashMap<Integer, List> responsesByCorrelationId = new HashMap<Integer, List>();
        for (int i = 0; i < this.m_children.length; ++i) {
            responsesByCorrelationId.put(i, new ArrayList());
        }
        responses.forEach(r -> CorrelationIdUtils.popIndexFromCollerationId(r, responsesByCorrelationId));
        responsesByCorrelationId.forEach((index, value) -> {
            if (index < 0 || index > this.m_children.length - 1) {
                LOG.warn("Invalid index on response: {}, {}, {}", new Object[]{index, value, this.m_children.length});
            } else {
                this.m_children[index].handleWalkResponses((List<WalkResponse>)value);
            }
        });
    }

    public void printSnmpData() {
    }

    private static final class ChildTrackerPduBuilder
    extends PduBuilder {
        private final List<SnmpObjId> m_oids = new ArrayList<SnmpObjId>();
        private int m_nonRepeaters = 0;
        private int m_maxRepititions = 0;
        private ResponseProcessor m_responseProcessor;
        private int m_nonRepeaterStartIndex;
        private int m_repeaterStartIndex;

        public ChildTrackerPduBuilder(int maxVarsPerPdu) {
            super(maxVarsPerPdu);
        }

        @Override
        public void addOid(SnmpObjId snmpObjId) {
            this.m_oids.add(snmpObjId);
        }

        @Override
        public void setNonRepeaters(int nonRepeaters) {
            this.m_nonRepeaters = nonRepeaters;
        }

        public int getNonRepeaters() {
            return this.m_nonRepeaters;
        }

        public int getRepeaters() {
            return this.size() - this.getNonRepeaters();
        }

        @Override
        public void setMaxRepetitions(int maxRepititions) {
            this.m_maxRepititions = maxRepititions;
        }

        public int getMaxRepititions() {
            return this.hasRepeaters() ? this.m_maxRepititions : Integer.MAX_VALUE;
        }

        public int size() {
            return this.m_oids.size();
        }

        public void setResponseProcessor(ResponseProcessor responseProcessor) {
            this.m_responseProcessor = responseProcessor;
        }

        public ResponseProcessor getResponseProcessor() {
            return this.m_responseProcessor;
        }

        public void addNonRepeaters(PduBuilder pduBuilder) {
            for (int i = 0; i < this.m_nonRepeaters; ++i) {
                SnmpObjId oid = this.m_oids.get(i);
                pduBuilder.addOid(oid);
            }
        }

        public void addRepeaters(PduBuilder pduBuilder) {
            for (int i = this.m_nonRepeaters; i < this.m_oids.size(); ++i) {
                SnmpObjId oid = this.m_oids.get(i);
                pduBuilder.addOid(oid);
            }
        }

        public boolean hasRepeaters() {
            return this.getNonRepeaters() < this.size();
        }

        public void setNonRepeaterStartIndex(int nonRepeaterStartIndex) {
            this.m_nonRepeaterStartIndex = nonRepeaterStartIndex;
        }

        public int getNonRepeaterStartIndex() {
            return this.m_nonRepeaterStartIndex;
        }

        public void setRepeaterStartIndex(int repeaterStartIndex) {
            this.m_repeaterStartIndex = repeaterStartIndex;
        }

        public int getRepeaterStartIndex() {
            return this.m_repeaterStartIndex;
        }

        boolean isNonRepeater(int canonicalIndex) {
            return this.getNonRepeaterStartIndex() <= canonicalIndex && canonicalIndex < this.getNonRepeaterStartIndex() + this.getNonRepeaters();
        }

        boolean isRepeater(int canonicalIndex) {
            return this.getRepeaterStartIndex() <= canonicalIndex && canonicalIndex < this.getRepeaterStartIndex() + this.getRepeaters();
        }

        public int getChildIndex(int canonicalIndex) throws SnmpException {
            if (this.isNonRepeater(canonicalIndex)) {
                return canonicalIndex - this.getNonRepeaterStartIndex();
            }
            if (this.isRepeater(canonicalIndex)) {
                return canonicalIndex - this.getRepeaterStartIndex() + this.getNonRepeaters();
            }
            throw new SnmpException("index out of range for tracker " + String.valueOf(this));
        }
    }

    private static class ChildTrackerResponseProcessor
    implements ResponseProcessor {
        private final CollectionTracker m_tracker;
        private final int m_repeaters;
        private final PduBuilder m_pduBuilder;
        private final int m_nonRepeaters;
        private final List<ChildTrackerPduBuilder> m_childPduBuilders;
        private int m_currResponseIndex = 0;

        public ChildTrackerResponseProcessor(CollectionTracker tracker, PduBuilder pduBuilder, List<ChildTrackerPduBuilder> builders, int nonRepeaters, int repeaters) {
            this.m_tracker = tracker;
            this.m_repeaters = repeaters;
            this.m_pduBuilder = pduBuilder;
            this.m_nonRepeaters = nonRepeaters;
            this.m_childPduBuilders = builders;
        }

        @Override
        public void processResponse(SnmpObjId snmpObjId, SnmpValue val) throws SnmpException {
            ChildTrackerPduBuilder childBuilder = this.getChildBuilder(this.m_currResponseIndex++);
            childBuilder.getResponseProcessor().processResponse(snmpObjId, val);
        }

        public boolean processChildError(int errorStatus, int errorIndex) throws SnmpException {
            int canonicalIndex = this.getCanonicalIndex(errorIndex - 1);
            ChildTrackerPduBuilder childBuilder = this.getChildBuilder(canonicalIndex);
            int childIndex = childBuilder.getChildIndex(canonicalIndex);
            return childBuilder.getResponseProcessor().processErrors(errorStatus, childIndex + 1);
        }

        private ChildTrackerPduBuilder getChildBuilder(int zeroBasedIndex) throws SnmpException {
            int canonicalIndex = this.getCanonicalIndex(zeroBasedIndex);
            for (ChildTrackerPduBuilder childBuilder : this.m_childPduBuilders) {
                if (!childBuilder.isNonRepeater(canonicalIndex) && !childBuilder.isRepeater(canonicalIndex)) continue;
                return childBuilder;
            }
            throw new SnmpException("Unable to find childBuilder for index " + zeroBasedIndex);
        }

        private int getCanonicalIndex(int zeroBasedIndex) {
            if (zeroBasedIndex <= 0) {
                return 0;
            }
            if (zeroBasedIndex < this.m_nonRepeaters) {
                return zeroBasedIndex;
            }
            return (zeroBasedIndex - this.m_nonRepeaters) % this.m_repeaters + this.m_nonRepeaters;
        }

        @Override
        public boolean processErrors(int errorStatus, int errorIndex) throws SnmpException {
            ErrorStatus status = ErrorStatus.fromStatus(errorStatus);
            if (status == ErrorStatus.TOO_BIG) {
                int maxVarsPerPdu = this.m_pduBuilder.getMaxVarsPerPdu();
                if (maxVarsPerPdu <= 1) {
                    throw new SnmpException("Unable to handle tooBigError when maxVarsPerPdu = " + maxVarsPerPdu);
                }
                this.m_pduBuilder.setMaxVarsPerPdu(maxVarsPerPdu / 2);
                this.m_tracker.reportTooBigErr("Reducing maxVarsPerPDU for this request.");
                return true;
            }
            if (status.isFatal()) {
                ErrorStatusException ex = new ErrorStatusException(status);
                this.m_tracker.reportFatalErr(ex);
                throw ex;
            }
            return this.processChildError(errorStatus, errorIndex);
        }
    }
}

