/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.reporting.dao;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.opennms.core.xml.JaxbUtils;
import org.opennms.features.reporting.dao.LocalReportsDao;
import org.opennms.features.reporting.model.basicreport.BasicReportDefinition;
import org.opennms.features.reporting.model.basicreport.LegacyLocalReportsDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.util.Assert;

public class LegacyLocalReportsDao
implements LocalReportsDao {
    private Logger logger = LoggerFactory.getLogger(LegacyLocalReportsDao.class);
    private LegacyLocalReportsDefinition m_legacyLocalReportsDefinition;
    private Resource m_configResource;

    public LegacyLocalReportsDao(Resource configResource) {
        this.m_configResource = configResource;
        Assert.notNull((Object)this.m_configResource, (String)"property configResource must be set to a non-null value");
        this.logger.debug("Config resource is set to " + this.m_configResource.toString());
        try {
            this.loadConfiguration();
        }
        catch (Exception e) {
            this.logger.error("Error could not load database-reports.xml. Error message: '{}'", (Object)e.getMessage());
        }
        this.logger.debug("Configuration '{}' successfully loaded and unmarshalled.", (Object)this.m_configResource.getFilename());
    }

    @Override
    public void loadConfiguration() throws Exception {
        File file = null;
        try {
            file = this.m_configResource.getFile();
            Assert.notNull((Object)file, (String)"config file must be sot to a non-null value");
        }
        catch (IOException e) {
            this.logger.error("Resource '{}' does not seem to have an underlying File object.", (Object)this.m_configResource, (Object)e);
            return;
        }
        this.setLegacyLocalReportsDefinition((LegacyLocalReportsDefinition)JaxbUtils.unmarshal(LegacyLocalReportsDefinition.class, (File)file));
        Assert.notNull((Object)this.m_legacyLocalReportsDefinition, (String)"unmarshall config file returned a null value.");
        this.logger.debug("Unmarshalling config file '{}'", (Object)file.getAbsolutePath());
        this.logger.debug("Local report definitions assigned: '{}'", (Object)this.m_legacyLocalReportsDefinition);
    }

    @Override
    public void setConfigResource(Resource configResource) {
        this.m_configResource = configResource;
    }

    @Override
    public Resource getConfigResource() {
        return this.m_configResource;
    }

    @Override
    public List<BasicReportDefinition> getReports() {
        ArrayList<BasicReportDefinition> resultList = new ArrayList<BasicReportDefinition>();
        for (BasicReportDefinition report : this.m_legacyLocalReportsDefinition.getReportList()) {
            resultList.add(report);
        }
        return resultList;
    }

    @Override
    public List<BasicReportDefinition> getOnlineReports() {
        ArrayList<BasicReportDefinition> onlineReports = new ArrayList<BasicReportDefinition>();
        for (BasicReportDefinition report : this.m_legacyLocalReportsDefinition.getReportList()) {
            if (!report.getOnline()) continue;
            onlineReports.add(report);
        }
        return onlineReports;
    }

    @Override
    public String getReportService(String id) {
        for (BasicReportDefinition report : this.m_legacyLocalReportsDefinition.getReportList()) {
            if (!id.equals(report.getId())) continue;
            return report.getReportService();
        }
        return null;
    }

    @Override
    public String getDisplayName(String id) {
        for (BasicReportDefinition report : this.m_legacyLocalReportsDefinition.getReportList()) {
            if (!id.equals(report.getId())) continue;
            return report.getDisplayName();
        }
        return null;
    }

    public void setLegacyLocalReportsDefinition(LegacyLocalReportsDefinition legacyLocalReportsDefinition) {
        this.m_legacyLocalReportsDefinition = legacyLocalReportsDefinition;
    }

    public LegacyLocalReportsDefinition getLegacyLocalReportsDefinition() {
        return this.m_legacyLocalReportsDefinition;
    }
}

