/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.rest.v2;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.net.URI;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.container.ResourceContext;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;
import org.apache.cxf.jaxrs.ext.search.SearchBean;
import org.opennms.core.config.api.JaxbListWrapper;
import org.opennms.core.criteria.Alias;
import org.opennms.core.criteria.CriteriaBuilder;
import org.opennms.core.criteria.restrictions.Restriction;
import org.opennms.core.criteria.restrictions.Restrictions;
import org.opennms.netmgt.dao.api.MonitoringLocationDao;
import org.opennms.netmgt.dao.api.NodeDao;
import org.opennms.netmgt.events.api.EventProxy;
import org.opennms.netmgt.model.OnmsMetaData;
import org.opennms.netmgt.model.OnmsMetaDataList;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.OnmsNodeList;
import org.opennms.netmgt.model.events.EventUtils;
import org.opennms.netmgt.model.monitoringLocations.OnmsMonitoringLocation;
import org.opennms.netmgt.xml.event.Event;
import org.opennms.web.api.RestUtils;
import org.opennms.web.rest.support.Aliases;
import org.opennms.web.rest.support.CriteriaBehavior;
import org.opennms.web.rest.support.CriteriaBehaviors;
import org.opennms.web.rest.support.MultivaluedMapImpl;
import org.opennms.web.rest.support.RedirectHelper;
import org.opennms.web.rest.support.SearchProperties;
import org.opennms.web.rest.support.SearchProperty;
import org.opennms.web.rest.v2.AbstractDaoRestService;
import org.opennms.web.rest.v2.NodeCategoriesRestService;
import org.opennms.web.rest.v2.NodeHardwareInventoryRestService;
import org.opennms.web.rest.v2.NodeIpInterfacesRestService;
import org.opennms.web.rest.v2.NodeSnmpInterfacesRestService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@Path(value="nodes")
@Transactional
@Tag(name="Nodes", description="Node API")
public class NodeRestService
extends AbstractDaoRestService<OnmsNode, SearchBean, Integer, String> {
    private static final Logger LOG = LoggerFactory.getLogger(NodeRestService.class);
    @Autowired
    private MonitoringLocationDao m_locationDao;
    @Autowired
    private NodeDao m_dao;
    @Autowired
    @Qualifier(value="eventProxy")
    private EventProxy m_eventProxy;

    protected NodeDao getDao() {
        return this.m_dao;
    }

    @Override
    protected Class<OnmsNode> getDaoClass() {
        return OnmsNode.class;
    }

    @Override
    protected Class<SearchBean> getQueryBeanClass() {
        return SearchBean.class;
    }

    @Override
    protected CriteriaBuilder getCriteriaBuilder(UriInfo uriInfo) {
        CriteriaBuilder builder = new CriteriaBuilder(OnmsNode.class, Aliases.node.toString());
        builder.alias("assetRecord", Aliases.assetRecord.toString(), Alias.JoinType.LEFT_JOIN);
        builder.alias("location", Aliases.location.toString(), Alias.JoinType.LEFT_JOIN);
        builder.orderBy("label").desc();
        return builder;
    }

    @Override
    protected Set<SearchProperty> getQueryProperties() {
        return SearchProperties.NODE_SERVICE_PROPERTIES;
    }

    @Override
    protected Map<String, CriteriaBehavior<?>> getCriteriaBehaviors() {
        HashMap map = new HashMap();
        map.putAll(CriteriaBehaviors.NODE_BEHAVIORS);
        map.putAll(CriteriaBehaviors.withAliasPrefix(Aliases.assetRecord, CriteriaBehaviors.ASSET_RECORD_BEHAVIORS));
        map.putAll(CriteriaBehaviors.withAliasPrefix(Aliases.category, CriteriaBehaviors.NODE_CATEGORY_BEHAVIORS));
        for (Map.Entry<String, CriteriaBehavior<?>> entry : CriteriaBehaviors.IP_INTERFACE_BEHAVIORS.entrySet()) {
            map.put(Aliases.ipInterface.prop(entry.getKey()), new CriteriaBehavior(entry.getValue().getPropertyName(), entry.getValue().getConverter(), (b, v, c, w) -> b.alias("ipInterfaces", Aliases.ipInterface.toString(), Alias.JoinType.LEFT_JOIN, (Restriction)Restrictions.or((Restriction[])new Restriction[]{Restrictions.eq((String)Aliases.ipInterface.prop((String)entry.getKey()), (Object)v), Restrictions.isNull((String)Aliases.ipInterface.prop((String)entry.getKey()))}))));
        }
        for (String prop : new String[]{"ipHostName", "isManaged"}) {
            map.put(Aliases.ipInterface.prop(prop), new CriteriaBehavior<String>(null, String::new, (b, v, c, w) -> b.alias("ipInterfaces", Aliases.ipInterface.toString(), Alias.JoinType.LEFT_JOIN, (Restriction)Restrictions.or((Restriction[])new Restriction[]{Restrictions.eq((String)Aliases.ipInterface.prop(prop), (Object)v), Restrictions.isNull((String)Aliases.ipInterface.prop(prop))}))));
        }
        map.putAll(CriteriaBehaviors.withAliasPrefix(Aliases.location, CriteriaBehaviors.MONITORING_LOCATION_BEHAVIORS));
        for (Map.Entry entry : CriteriaBehaviors.SNMP_INTERFACE_BEHAVIORS.entrySet()) {
            map.put(Aliases.snmpInterface.prop((String)entry.getKey()), new CriteriaBehavior(((CriteriaBehavior)entry.getValue()).getPropertyName(), ((CriteriaBehavior)entry.getValue()).getConverter(), (b, v, c, w) -> b.alias("snmpInterfaces", Aliases.snmpInterface.toString(), Alias.JoinType.LEFT_JOIN, (Restriction)Restrictions.or((Restriction[])new Restriction[]{Restrictions.eq((String)Aliases.snmpInterface.prop((String)entry.getKey()), (Object)v), Restrictions.isNull((String)Aliases.snmpInterface.prop((String)entry.getKey()))}))));
        }
        return map;
    }

    @Override
    protected JaxbListWrapper<OnmsNode> createListWrapper(Collection<OnmsNode> list) {
        return new OnmsNodeList(list);
    }

    @Override
    public Response doCreate(SecurityContext securityContext, UriInfo uriInfo, OnmsNode object) {
        if (object == null) {
            throw NodeRestService.getException(Response.Status.BAD_REQUEST, "Node object cannot be null", new String[0]);
        }
        if (object.getLocation() == null) {
            OnmsMonitoringLocation location = this.m_locationDao.getDefaultLocation();
            LOG.debug("doCreate: Assigning new node to default location: {}", (Object)location.getLocationName());
            object.setLocation(location);
        }
        if (object.getAssetRecord() != null && object.getAssetRecord().getNode() == null) {
            object.getAssetRecord().setNode(object);
        }
        Integer id = (Integer)this.getDao().save((Object)object);
        Event e = EventUtils.createNodeAddedEvent((String)"Rest", (int)id, (String)object.getLabel(), (OnmsNode.NodeLabelSource)object.getLabelSource(), null);
        this.sendEvent(e);
        return Response.created((URI)RedirectHelper.getRedirectUri(uriInfo, id)).build();
    }

    @Override
    protected Response doUpdateProperties(SecurityContext securityContext, UriInfo uriInfo, OnmsNode targetObject, MultivaluedMapImpl params) {
        RestUtils.setBeanProperties((Object)targetObject, (MultivaluedMap)params);
        this.getDao().update((Object)targetObject);
        return Response.noContent().build();
    }

    @Override
    protected void doDelete(SecurityContext securityContext, UriInfo uriInfo, OnmsNode node) {
        this.getDao().delete((Object)node);
        Event e = EventUtils.createDeleteNodeEvent((String)"ReST", (long)node.getId().intValue(), (long)-1L);
        this.sendEvent(e);
    }

    @Override
    protected OnmsNode doGet(UriInfo uriInfo, String id) {
        return this.getDao().get(id);
    }

    @Path(value="{nodeCriteria}/ipinterfaces")
    public NodeIpInterfacesRestService getIpInterfaceResource(@Context ResourceContext context) {
        return (NodeIpInterfacesRestService)context.getResource(NodeIpInterfacesRestService.class);
    }

    @Path(value="{nodeCriteria}/snmpinterfaces")
    public NodeSnmpInterfacesRestService getSnmpInterfaceResource(@Context ResourceContext context) {
        return (NodeSnmpInterfacesRestService)context.getResource(NodeSnmpInterfacesRestService.class);
    }

    @Path(value="{nodeCriteria}/hardwareInventory")
    public NodeHardwareInventoryRestService getHardwareInventoryResource(@Context ResourceContext context) {
        return (NodeHardwareInventoryRestService)context.getResource(NodeHardwareInventoryRestService.class);
    }

    @Path(value="{nodeCriteria}/categories")
    public NodeCategoriesRestService getCategoriesResource(@Context ResourceContext context) {
        return (NodeCategoriesRestService)context.getResource(NodeCategoriesRestService.class);
    }

    @PUT
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Path(value="{nodeCriteria}/rescan")
    @Operation(summary="Rescan node by NodeId", description="Rescan node by NodeId", operationId="NodeRestServicePUTRescanNodeByNodeId")
    public Response rescanNode(@PathParam(value="nodeCriteria") String nodeCriteria) {
        OnmsNode node = this.m_dao.get(nodeCriteria);
        if (node == null) {
            throw NodeRestService.getException(Response.Status.NOT_FOUND, "Node {} was not found.", nodeCriteria);
        }
        Event e = EventUtils.createNodeRescanEvent((String)"ReST", (Integer)node.getId());
        this.sendEvent(e);
        return Response.ok().build();
    }

    @GET
    @Path(value="{nodeCriteria}/metadata")
    @Produces(value={"application/json", "application/xml", "application/atom+xml"})
    @Operation(summary="Get Metadata by NodeId", description="Get Metadata by NodeId", operationId="NodeRestServiceGETMetaDataByNodeId")
    public OnmsMetaDataList getMetaData(@PathParam(value="nodeCriteria") String nodeCriteria) {
        OnmsNode node = this.getDao().get(nodeCriteria);
        if (node == null) {
            throw NodeRestService.getException(Response.Status.BAD_REQUEST, "getMetaData: Can't find node " + nodeCriteria, new String[0]);
        }
        return new OnmsMetaDataList((Collection)node.getMetaData());
    }

    @GET
    @Path(value="{nodeCriteria}/metadata/{context}")
    @Produces(value={"application/json", "application/xml", "application/atom+xml"})
    @Operation(summary="Get Metadata by NodeId and Context", description="Get Metadata by NodeId and Context", operationId="NodeRestServiceGETMetaDataByNodeIdAndContext")
    public OnmsMetaDataList getMetaData(@PathParam(value="nodeCriteria") String nodeCriteria, @PathParam(value="context") String context) {
        OnmsNode node = this.getDao().get(nodeCriteria);
        if (node == null) {
            throw NodeRestService.getException(Response.Status.BAD_REQUEST, "getMetaData: Can't find node " + nodeCriteria, new String[0]);
        }
        return new OnmsMetaDataList((Collection)node.getMetaData().stream().filter(e -> context.equals(e.getContext())).collect(Collectors.toList()));
    }

    @GET
    @Path(value="{nodeCriteria}/metadata/{context}/{key}")
    @Produces(value={"application/json", "application/xml", "application/atom+xml"})
    @Operation(summary="Get Metadata by NodeId, Context and Key", description="Get Metadata by NodeId, Context and Key", operationId="NodeRestServiceGETMetaDataByNodeIdAndContextAndKey")
    public OnmsMetaDataList getMetaData(@PathParam(value="nodeCriteria") String nodeCriteria, @PathParam(value="context") String context, @PathParam(value="key") String key) {
        OnmsNode node = this.getDao().get(nodeCriteria);
        if (node == null) {
            throw NodeRestService.getException(Response.Status.BAD_REQUEST, "getMetaData: Can't find node " + nodeCriteria, new String[0]);
        }
        return new OnmsMetaDataList((Collection)node.getMetaData().stream().filter(e -> context.equals(e.getContext()) && key.equals(e.getKey())).collect(Collectors.toList()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @DELETE
    @Path(value="{nodeCriteria}/metadata/{context}")
    @Produces(value={"application/json", "application/xml", "application/atom+xml"})
    public Response deleteMetaData(@PathParam(value="nodeCriteria") String nodeCriteria, @PathParam(value="context") String context) {
        NodeRestService.checkUserDefinedMetadataContext(context);
        this.writeLock();
        try {
            OnmsNode node = this.getDao().get(nodeCriteria);
            if (node == null) {
                throw NodeRestService.getException(Response.Status.BAD_REQUEST, "deleteMetaData: Can't find node " + nodeCriteria, new String[0]);
            }
            node.removeMetaData(context);
            this.getDao().update((Object)node);
            Response response = Response.noContent().build();
            return response;
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @DELETE
    @Path(value="{nodeCriteria}/metadata/{context}/{key}")
    @Produces(value={"application/json", "application/xml", "application/atom+xml"})
    public Response deleteMetaData(@PathParam(value="nodeCriteria") String nodeCriteria, @PathParam(value="context") String context, @PathParam(value="key") String key) {
        NodeRestService.checkUserDefinedMetadataContext(context);
        this.writeLock();
        try {
            OnmsNode node = this.getDao().get(nodeCriteria);
            if (node == null) {
                throw NodeRestService.getException(Response.Status.BAD_REQUEST, "deleteMetaData: Can't find node " + nodeCriteria, new String[0]);
            }
            node.removeMetaData(context, key);
            this.getDao().update((Object)node);
            Response response = Response.noContent().build();
            return response;
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Path(value="{nodeCriteria}/metadata")
    @Produces(value={"application/json", "application/xml", "application/atom+xml"})
    public Response postMetaData(@PathParam(value="nodeCriteria") String nodeCriteria, OnmsMetaData entity) {
        NodeRestService.checkUserDefinedMetadataContext(entity.getContext());
        this.writeLock();
        try {
            OnmsNode node = this.getDao().get(nodeCriteria);
            if (node == null) {
                throw NodeRestService.getException(Response.Status.BAD_REQUEST, "postMetaData: Can't find node " + nodeCriteria, new String[0]);
            }
            node.addMetaData(entity.getContext(), entity.getKey(), entity.getValue());
            this.getDao().update((Object)node);
            Response response = Response.noContent().build();
            return response;
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PUT
    @Path(value="{nodeCriteria}/metadata/{context}/{key}/{value}")
    @Produces(value={"application/json", "application/xml", "application/atom+xml"})
    public Response putMetaData(@PathParam(value="nodeCriteria") String nodeCriteria, @PathParam(value="context") String context, @PathParam(value="key") String key, @PathParam(value="value") String value) {
        NodeRestService.checkUserDefinedMetadataContext(context);
        this.writeLock();
        try {
            OnmsNode node = this.getDao().get(nodeCriteria);
            if (node == null) {
                throw NodeRestService.getException(Response.Status.BAD_REQUEST, "putMetaData: Can't find node " + nodeCriteria, new String[0]);
            }
            node.addMetaData(context, key, value);
            this.getDao().update((Object)node);
            Response response = Response.noContent().build();
            return response;
        }
        finally {
            this.writeUnlock();
        }
    }
}

