/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.rest.v2;

import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.Path;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.cxf.jaxrs.ext.search.SearchBean;
import org.opennms.core.config.api.JaxbListWrapper;
import org.opennms.core.criteria.Alias;
import org.opennms.core.criteria.CriteriaBuilder;
import org.opennms.netmgt.dao.api.IpInterfaceDao;
import org.opennms.netmgt.model.OnmsIpInterface;
import org.opennms.netmgt.model.OnmsIpInterfaceList;
import org.opennms.web.rest.support.Aliases;
import org.opennms.web.rest.support.CriteriaBehavior;
import org.opennms.web.rest.support.CriteriaBehaviors;
import org.opennms.web.rest.support.SearchProperties;
import org.opennms.web.rest.support.SearchProperty;
import org.opennms.web.rest.v2.AbstractDaoRestService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@Path(value="ipinterfaces")
@Transactional
@Tag(name="IpInterfaces", description="Ip Interfaces API")
public class IpInterfaceRestService
extends AbstractDaoRestService<OnmsIpInterface, SearchBean, Integer, String> {
    @Autowired
    private IpInterfaceDao m_dao;

    protected IpInterfaceDao getDao() {
        return this.m_dao;
    }

    @Override
    protected Class<OnmsIpInterface> getDaoClass() {
        return OnmsIpInterface.class;
    }

    @Override
    protected Class<SearchBean> getQueryBeanClass() {
        return SearchBean.class;
    }

    @Override
    protected CriteriaBuilder getCriteriaBuilder(UriInfo uriInfo) {
        CriteriaBuilder builder = new CriteriaBuilder(this.getDaoClass());
        builder.alias("node", Aliases.node.toString(), Alias.JoinType.LEFT_JOIN);
        builder.alias("snmpInterface", Aliases.snmpInterface.toString(), Alias.JoinType.LEFT_JOIN);
        builder.alias(Aliases.node.prop("assetRecord"), Aliases.assetRecord.toString(), Alias.JoinType.LEFT_JOIN);
        builder.alias(Aliases.node.prop("location"), Aliases.location.toString(), Alias.JoinType.LEFT_JOIN);
        builder.orderBy("id");
        return builder;
    }

    @Override
    protected final JaxbListWrapper<OnmsIpInterface> createListWrapper(Collection<OnmsIpInterface> list) {
        return new OnmsIpInterfaceList(list);
    }

    @Override
    protected Set<SearchProperty> getQueryProperties() {
        return SearchProperties.IP_INTERFACE_SERVICE_PROPERTIES;
    }

    @Override
    protected Map<String, CriteriaBehavior<?>> getCriteriaBehaviors() {
        HashMap map = new HashMap();
        map.putAll(CriteriaBehaviors.IP_INTERFACE_BEHAVIORS);
        map.putAll(CriteriaBehaviors.withAliasPrefix(Aliases.node, CriteriaBehaviors.NODE_BEHAVIORS));
        map.putAll(CriteriaBehaviors.withAliasPrefix(Aliases.snmpInterface, CriteriaBehaviors.SNMP_INTERFACE_BEHAVIORS));
        map.putAll(CriteriaBehaviors.withAliasPrefix(Aliases.assetRecord, CriteriaBehaviors.ASSET_RECORD_BEHAVIORS));
        map.putAll(CriteriaBehaviors.withAliasPrefix(Aliases.location, CriteriaBehaviors.MONITORING_LOCATION_BEHAVIORS));
        return map;
    }

    @Override
    protected final OnmsIpInterface doGet(UriInfo uriInfo, String ipAddress) {
        List addresses = this.getDao().findByIpAddress(ipAddress);
        if (addresses.isEmpty()) {
            return null;
        }
        if (addresses.size() == 1) {
            OnmsIpInterface iface = (OnmsIpInterface)addresses.get(0);
            this.getDao().initialize((Object)iface.getSnmpInterface());
            return iface;
        }
        throw new WebApplicationException("More than one IP address matches " + ipAddress, Response.Status.BAD_REQUEST);
    }
}

