/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.rest.v2;

import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.persistence.EntityNotFoundException;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.StreamingOutput;
import org.apache.commons.lang.StringUtils;
import org.apache.cxf.jaxrs.ext.multipart.Attachment;
import org.opennms.core.xml.JaxbUtils;
import org.opennms.netmgt.dao.api.EventConfEventDao;
import org.opennms.netmgt.dao.api.EventConfSourceDao;
import org.opennms.netmgt.model.EventConfEvent;
import org.opennms.netmgt.model.EventConfEventDto;
import org.opennms.netmgt.model.EventConfSource;
import org.opennms.netmgt.model.events.EnableDisableConfSourceEventsPayload;
import org.opennms.netmgt.model.events.EventConfSourceDeletePayload;
import org.opennms.netmgt.model.events.EventConfSourceMetadataDto;
import org.opennms.netmgt.model.events.EventConfSrcEnableDisablePayload;
import org.opennms.netmgt.xml.eventconf.Event;
import org.opennms.netmgt.xml.eventconf.Events;
import org.opennms.web.rest.v2.EventConfPersistenceService;
import org.opennms.web.rest.v2.api.EventConfRestApi;
import org.opennms.web.rest.v2.model.AddEventConfSourceRequest;
import org.opennms.web.rest.v2.model.EventConfEventDeletePayload;
import org.opennms.web.rest.v2.model.EventConfEventEditRequest;
import org.opennms.web.rest.v2.model.EventConfSourceDto;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.stereotype.Component;

@Component
public class EventConfRestService
implements EventConfRestApi {
    private static final Logger LOG = LoggerFactory.getLogger(EventConfRestService.class);
    private static final int VENDOR_MAX_LENGTH = 128;
    @Autowired
    private EventConfPersistenceService eventConfPersistenceService;
    @Autowired
    private EventConfSourceDao eventConfSourceDao;
    @Autowired
    private EventConfEventDao eventConfEventDao;

    @Override
    public Response uploadEventConfFiles(List<Attachment> attachments, SecurityContext securityContext) {
        String username = this.getUsername(securityContext);
        Date now = new Date();
        int maxFileOrder = Optional.ofNullable(this.eventConfSourceDao.findMaxFileOrder()).orElse(0);
        LinkedHashMap<String, Attachment> fileMap = new LinkedHashMap<String, Attachment>();
        for (Attachment attachment : attachments) {
            String filename = attachment.getContentDisposition().getParameter("filename");
            String basename = this.stripPathAndExtension(filename);
            if (basename == null || basename.isEmpty()) {
                LOG.warn("Skipping attachment with invalid filename: {}", (Object)filename);
                continue;
            }
            if (fileMap.containsKey(basename)) {
                String existingFilename = ((Attachment)fileMap.get(basename)).getContentDisposition().getParameter("filename");
                LOG.warn("Duplicate basename detected: '{}' and '{}' resolve to same name '{}'. Keeping first file.", new Object[]{existingFilename, filename, basename});
                continue;
            }
            fileMap.put(basename, attachment);
        }
        ArrayList orderedFiles = new ArrayList(fileMap.keySet());
        ArrayList<Map<String, Object>> successList = new ArrayList<Map<String, Object>>();
        ArrayList<Map<String, Object>> errorList = new ArrayList<Map<String, Object>>();
        long dbStartTime = System.currentTimeMillis();
        for (String fileName : orderedFiles) {
            Events fileEvents;
            Attachment attachment = (Attachment)fileMap.get(fileName);
            if (attachment == null) continue;
            try (InputStream stream = (InputStream)attachment.getObject(InputStream.class);){
                fileEvents = this.parseEventFile(new ByteArrayInputStream(stream.readAllBytes()));
            }
            catch (Exception e) {
                errorList.add(this.buildErrorResponse(fileName, e));
                continue;
            }
            try {
                EventConfSource existingSource = this.eventConfSourceDao.findByName(fileName);
                int fileOrder = existingSource != null ? existingSource.getFileOrder() : ++maxFileOrder;
                this.eventConfPersistenceService.persistEventConfFile(fileEvents, this.buildMetadata(fileName, "", fileEvents, fileOrder, username, now));
                successList.add(this.buildSuccessResponse(fileName, fileEvents));
            }
            catch (Exception e) {
                errorList.add(this.buildErrorResponse(fileName, e));
            }
        }
        long dbEndTime = System.currentTimeMillis();
        LOG.info("Time to add {} files to DB: {} ms", (Object)orderedFiles.size(), (Object)(dbEndTime - dbStartTime));
        this.eventConfPersistenceService.reloadEventsIntoMemory();
        return Response.ok(Map.of("success", successList, "errors", errorList)).build();
    }

    @Override
    public Response filterEventConf(String uei, String vendor, String sourceName, int offset, int limit, SecurityContext securityContext) {
        if (offset < 0 || limit < 1) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        List<EventConfEvent> results = this.eventConfPersistenceService.findEventConfByFilters(uei, vendor, sourceName, offset, limit);
        if (results == null || results.isEmpty()) {
            return Response.noContent().build();
        }
        List dtoList = EventConfEventDto.fromEntity(results);
        return Response.ok((Object)dtoList).build();
    }

    @Override
    public Response enableDisableEventConfSources(EventConfSrcEnableDisablePayload payload, SecurityContext securityContext) throws Exception {
        if (payload == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Request body cannot be null").build();
        }
        if (payload.getEnabled() == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"The 'enabled' flag must be provided (true/false).").build();
        }
        if (payload.getSourceIds() == null || payload.getSourceIds().isEmpty()) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"At least one sourceId must be provided.").build();
        }
        try {
            this.eventConfPersistenceService.updateSourceAndEventEnabled(payload);
            this.eventConfPersistenceService.reloadEventsIntoMemory();
            return Response.ok().entity((Object)"EventConf sources updated successfully.").build();
        }
        catch (EntityNotFoundException ex) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)("One or more sourceIds were not found: " + ex.getMessage())).build();
        }
        catch (Exception ex) {
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)("Unexpected error occurred: " + ex.getMessage())).build();
        }
    }

    @Override
    public Response filterConfEventsBySourceId(Long sourceId, String eventFilter, String eventSortBy, String eventOrder, Integer totalRecords, Integer offset, Integer limit, SecurityContext securityContext) {
        if (Objects.requireNonNullElse(sourceId, 0L) <= 0L || Objects.requireNonNullElse(offset, 0) < 0 || Objects.requireNonNullElse(limit, 0) < 1) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity(Map.of("error", "Invalid sourceId/offset/limit values")).build();
        }
        Map<String, Object> result = this.eventConfPersistenceService.filterConfEventsBySourceId(sourceId, eventFilter, eventSortBy, eventOrder, totalRecords, offset, limit);
        if (result == null || result.isEmpty() || result.containsKey("totalRecords") && (Integer)result.get("totalRecords") == 0) {
            return Response.noContent().build();
        }
        List dtoList = EventConfEventDto.fromEntity((List)((List)result.get("eventConfEventList")));
        return Response.ok(Map.of("totalRecords", result.get("totalRecords"), "eventConfSourceList", dtoList)).build();
    }

    @Override
    public Response filterEventConfSource(String filter, String sortBy, String order, Integer totalRecords, Integer offset, Integer limit, SecurityContext securityContext) {
        if (Objects.requireNonNullElse(offset, 0) < 0 || Objects.requireNonNullElse(limit, 0) < 1) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity(Map.of("error", "Invalid offset/limit values")).build();
        }
        Map<String, Object> result = this.eventConfPersistenceService.filterEventConfSource(filter, sortBy, order, totalRecords, offset, limit);
        if (result == null || result.isEmpty() || result.containsKey("totalRecords") && (Integer)result.get("totalRecords") == 0) {
            return Response.noContent().build();
        }
        List<EventConfSourceDto> dtoList = EventConfSourceDto.fromEntity((List)result.get("eventConfSourceList"));
        return Response.ok(Map.of("totalRecords", result.get("totalRecords"), "eventConfSourceList", dtoList)).build();
    }

    @Override
    public Response deleteEventConfSources(EventConfSourceDeletePayload payload, SecurityContext securityContext) throws Exception {
        if (payload == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Request body cannot be null").build();
        }
        if (payload.getSourceIds() == null || payload.getSourceIds().isEmpty()) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"At least one sourceId must be provided.").build();
        }
        try {
            this.eventConfPersistenceService.deleteEventConfSources(payload);
            this.eventConfPersistenceService.reloadEventsIntoMemory();
            return Response.ok().entity((Object)"EventConf sources deleted successfully.").build();
        }
        catch (EntityNotFoundException ex) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)("One or more sourceIds were not found: " + ex.getMessage())).build();
        }
        catch (Exception ex) {
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)("Unexpected error occurred: " + ex.getMessage())).build();
        }
    }

    @Override
    public Response enableDisableEventConfSourcesEvents(Long sourceId, EnableDisableConfSourceEventsPayload payload, SecurityContext securityContext) throws Exception {
        if (payload == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Request body cannot be null").build();
        }
        if (payload.getEventsIds() == null || payload.getEventsIds().isEmpty()) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"At least one eventConfEventsIds must be provided.").build();
        }
        try {
            this.eventConfPersistenceService.enableDisableConfSourcesEvents(sourceId, payload);
            this.eventConfPersistenceService.reloadEventsIntoMemory();
            return Response.ok().entity((Object)"EventConfEvents updated successfully.").build();
        }
        catch (EntityNotFoundException ex) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)("One or more eventConfEvents were not found: " + ex.getMessage())).build();
        }
        catch (Exception ex) {
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)("Unexpected error occurred: " + ex.getMessage())).build();
        }
    }

    @Override
    public Response getEventConfSourcesNames(SecurityContext securityContext) throws Exception {
        try {
            List sourceNames = this.eventConfSourceDao.findAllNames();
            return Response.ok((Object)sourceNames).build();
        }
        catch (Exception e) {
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)("Failed to fetch EventConf source names: " + e.getMessage())).build();
        }
    }

    @Override
    public Response addEventConfSourceEvent(Long sourceId, Event event, SecurityContext securityContext) throws Exception {
        try {
            this.validateAddEvent(sourceId, event);
            String username = this.getUsername(securityContext);
            Long id = this.eventConfPersistenceService.addEventConfSourceEvent(sourceId, username, event);
            this.eventConfPersistenceService.reloadEventsIntoMemory();
            return Response.status((Response.Status)Response.Status.CREATED).entity((Object)id).build();
        }
        catch (EntityNotFoundException ex) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)("Source with ID " + sourceId + " not found")).build();
        }
        catch (IllegalArgumentException ex) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)("Invalid event payload: " + ex.getMessage())).build();
        }
    }

    @Override
    public Response updateEventConfEvent(Long sourceId, Long eventId, EventConfEventEditRequest payload, SecurityContext securityContext) throws Exception {
        if (payload == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Request body cannot be null").build();
        }
        try {
            this.eventConfPersistenceService.updateEventConfEvent(sourceId, eventId, payload);
            this.eventConfPersistenceService.reloadEventsIntoMemory();
            return Response.ok().entity((Object)"EventConfEvent updated successfully.").build();
        }
        catch (EntityNotFoundException ex) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)("eventConfEvent were not found: " + ex.getMessage())).build();
        }
        catch (Exception ex) {
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)("Unexpected error occurred: " + ex.getMessage())).build();
        }
    }

    @Override
    public Response deleteEventsForSource(Long sourceId, EventConfEventDeletePayload payload, SecurityContext securityContext) throws Exception {
        if (sourceId == null || sourceId <= 0L) {
            throw new IllegalArgumentException("Invalid sourceId: must be a positive number");
        }
        if (payload == null || payload.getEventIds() == null || payload.getEventIds().isEmpty()) {
            throw new IllegalArgumentException("Event IDs to delete must not be null or empty");
        }
        try {
            this.eventConfPersistenceService.deleteEventsForSource(sourceId, payload);
            this.eventConfPersistenceService.reloadEventsIntoMemory();
            return Response.ok().entity((Object)"EventConf events deleted successfully.").build();
        }
        catch (EntityNotFoundException ex) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)("One or more eventIds were not found: " + ex.getMessage())).build();
        }
        catch (Exception ex) {
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)("Unexpected error occurred: " + ex.getMessage())).build();
        }
    }

    @Override
    public Response downloadEventConfXmlBySourceId(Long sourceId, SecurityContext securityContext) {
        if (sourceId == null || sourceId <= 0L) {
            return this.buildXmlError(Response.Status.BAD_REQUEST, "Invalid source ID");
        }
        EventConfSource eventConfSource = this.eventConfSourceDao.get(sourceId);
        if (eventConfSource == null || eventConfSource.getEvents().isEmpty()) {
            return this.buildXmlError(Response.Status.NOT_FOUND, "No events found for source ID: " + sourceId);
        }
        List eventConfEvents = this.eventConfEventDao.findBySourceId(sourceId);
        StreamingOutput stream = output -> {
            try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(output, StandardCharsets.UTF_8));){
                Events events = new Events();
                for (EventConfEvent eventConfEvent : eventConfEvents) {
                    if (eventConfEvent == null || eventConfEvent.getXmlContent() == null) continue;
                    try {
                        Event event = (Event)JaxbUtils.unmarshal(Event.class, (String)eventConfEvent.getXmlContent());
                        events.addEvent(event);
                    }
                    catch (Exception e) {
                        LOG.error("Failed to parse event XML for source {}: {}", (Object)sourceId, (Object)e.getMessage());
                    }
                }
                JaxbUtils.marshal((Object)events, (Writer)writer);
            }
        };
        return Response.ok((Object)stream).type("application/xml").header("Content-Disposition", (Object)"attachment; filename=\"%s.xml\"".formatted(eventConfSource.getName())).build();
    }

    @Override
    public Response getEventsByVendor(String vendorName, SecurityContext securityContext) {
        try {
            if (vendorName == null || vendorName.isBlank()) {
                LOG.warn("Vendor name is null or blank.");
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Vendor name must not be null or blank").build();
            }
            List results = this.eventConfEventDao.findEventsByVendor(vendorName);
            if (results == null || results.isEmpty()) {
                LOG.info("No events found for vendor: {}", (Object)vendorName);
                return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)("No events found for vendor: " + vendorName)).build();
            }
            List eventsDtoList = EventConfEventDto.fromEntity((List)results);
            return Response.ok((Object)eventsDtoList).build();
        }
        catch (Exception ex) {
            LOG.error("Error retrieving events for vendor: {}", (Object)vendorName, (Object)ex);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)("Error while retrieving events for vendor: " + vendorName + ". Cause: " + ex.getMessage())).build();
        }
    }

    @Override
    public Response addEventConfSource(AddEventConfSourceRequest request, SecurityContext securityContext) {
        Date now = new Date();
        try {
            this.validateAddSourceRequest(request);
        }
        catch (IllegalArgumentException ex) {
            LOG.warn("Validation failed for addEventConfSource request. reason={}", (Object)ex.getMessage());
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)("Invalid request: " + ex.getMessage())).build();
        }
        try {
            if (this.eventConfSourceDao.findByName(request.getName()) != null) {
                LOG.warn("Attempt to create duplicate EventConfSource. name='{}'", (Object)request.getName());
                return Response.status((Response.Status)Response.Status.CONFLICT).entity((Object)"An EventConfSource with the same name already exists").build();
            }
            String username = this.getUsername(securityContext);
            int maxFileOrder = Optional.ofNullable(this.eventConfSourceDao.findMaxFileOrder()).orElse(0);
            int newOrder = maxFileOrder + 1;
            LOG.debug("Assigned fileOrder={} for new EventConfSource name='{}'", (Object)newOrder, (Object)request.getName());
            EventConfSource eventConfSource = new EventConfSource();
            eventConfSource.setName(request.getName());
            eventConfSource.setDescription(request.getDescription());
            eventConfSource.setVendor(request.getVendor());
            eventConfSource.setEnabled(Boolean.valueOf(true));
            eventConfSource.setEventCount(Integer.valueOf(0));
            eventConfSource.setCreatedTime(now);
            eventConfSource.setLastModified(now);
            eventConfSource.setFileOrder(Integer.valueOf(newOrder));
            eventConfSource.setUploadedBy(username);
            LOG.debug("Persisting EventConfSource name='{}'", (Object)request.getName());
            Long eventConfSourceId = this.eventConfPersistenceService.createEventConfSource(eventConfSource);
            LOG.info("Successfully created EventConfSource id={}, name='{}', user='{}'", new Object[]{eventConfSourceId, request.getName(), username});
            return Response.status((Response.Status)Response.Status.CREATED).entity(Map.of("id", eventConfSourceId, "name", eventConfSource.getName(), "fileOrder", eventConfSource.getFileOrder())).build();
        }
        catch (DataIntegrityViolationException ex) {
            LOG.warn("Data integrity violation while creating EventConfSource name='{}'. Cause={}", new Object[]{request.getName(), ex.getMostSpecificCause().getMessage(), ex});
            return Response.status((Response.Status)Response.Status.CONFLICT).entity((Object)"EventConfSource could not be created due to a data integrity violation. It may already exist or violate database constraints.").build();
        }
        catch (Exception ex) {
            LOG.error("Failed to create EventConfSource name='{}'. Error={}", new Object[]{request.getName(), ex.getMessage(), ex});
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)"Unexpected error occurred while creating EventConfSource").build();
        }
    }

    private void validateAddSourceRequest(AddEventConfSourceRequest request) {
        if (request == null) {
            throw new IllegalArgumentException("Request must not be null.");
        }
        if (request.getName() == null || request.getName().isBlank()) {
            throw new IllegalArgumentException("Source name must not be null or blank.");
        }
        if (request.getVendor() == null || request.getVendor().isBlank()) {
            throw new IllegalArgumentException("Vendor must not be null or blank.");
        }
        String vendor = request.getVendor();
        if (vendor.length() > 128) {
            throw new IllegalArgumentException("Vendor length must not exceed 128 characters.");
        }
    }

    private Response buildXmlError(Response.Status status, String message) {
        return Response.status((Response.Status)status).entity((Object)"<error>%s</error>".formatted(message)).type("application/xml").build();
    }

    @Override
    public Response getEventConfSourceById(Long sourceId, SecurityContext securityContext) {
        try {
            if (sourceId == null || sourceId <= 0L) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity(Map.of("error", "Invalid sourceId provided")).build();
            }
            EventConfSource eventConfSource = this.eventConfSourceDao.get(sourceId);
            if (eventConfSource == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).entity(Map.of("error", "EventConfSource not found for id: " + sourceId)).build();
            }
            EventConfSourceDto eventConfSourceDto = EventConfSourceDto.fromEntity(eventConfSource);
            return Response.ok((Object)eventConfSourceDto).build();
        }
        catch (IllegalArgumentException e) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity(Map.of("error", e.getMessage())).build();
        }
        catch (Exception e) {
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity(Map.of("error", "Unexpected error occurred: " + e.getMessage())).build();
        }
    }

    private Events parseEventFile(InputStream inputStream) throws Exception {
        return (Events)JaxbUtils.unmarshal(Events.class, (InputStream)inputStream);
    }

    private String getUsername(SecurityContext context) {
        return context != null && context.getUserPrincipal() != null ? context.getUserPrincipal().getName() : "unknown";
    }

    private Map<String, Object> buildSuccessResponse(String filename, Events events) {
        LinkedHashMap<String, Object> entry = new LinkedHashMap<String, Object>();
        entry.put("file", filename);
        entry.put("eventCount", events.getEvents().size());
        entry.put("vendor", StringUtils.substringBefore((String)filename, (String)"."));
        List eventSummaries = events.getEvents().stream().map(e -> Map.of("uei", e.getUei(), "label", e.getEventLabel(), "description", e.getEventLabel(), "enabled", true)).collect(Collectors.toList());
        entry.put("events", eventSummaries);
        return entry;
    }

    private Map<String, Object> buildErrorResponse(String filename, Exception ex) {
        LinkedHashMap<String, Object> entry = new LinkedHashMap<String, Object>();
        entry.put("file", filename);
        entry.put("error", ex.getClass().getSimpleName() + ": " + ex.getMessage());
        return entry;
    }

    private EventConfSourceMetadataDto buildMetadata(String fileName, String description, Events events, int fileOrder, String username, Date now) {
        return new EventConfSourceMetadataDto.Builder().filename(fileName).eventCount(events.getEvents().size()).fileOrder(fileOrder).username(username).now(now).vendor(StringUtils.substringBefore((String)fileName, (String)".")).description(description).build();
    }

    private String stripPathAndExtension(String filename) {
        int dotIndex;
        if (filename == null) {
            return null;
        }
        String basename = filename;
        int lastSlash = Math.max(filename.lastIndexOf(47), filename.lastIndexOf(92));
        if (lastSlash != -1) {
            basename = filename.substring(lastSlash + 1);
        }
        String result = (dotIndex = basename.lastIndexOf(46)) == -1 ? basename : basename.substring(0, dotIndex);
        return result.trim();
    }

    private void validateAddEvent(Long sourceId, Event event) {
        if (sourceId == null || sourceId <= 0L) {
            throw new IllegalArgumentException("Invalid sourceId: must be a positive number");
        }
        EventConfSource eventConfSource = this.eventConfSourceDao.get(sourceId);
        if (eventConfSource == null) {
            throw new EntityNotFoundException("Source with id " + sourceId + " does not exist");
        }
        if (event == null) {
            throw new IllegalArgumentException("Event payload is missing");
        }
        this.requireNonBlank(event.getUei(), "Event 'uei' is required");
        this.requireNonBlank(event.getEventLabel(), "Event 'event-label' is required");
        this.requireNonBlank(event.getSeverity(), "Event 'severity' is required");
    }

    private void requireNonBlank(String value, String message) {
        if (value == null || value.isBlank()) {
            throw new IllegalArgumentException(message);
        }
    }
}

