/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.rest.v1;

import com.google.common.collect.Lists;
import com.google.gson.Gson;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.opennms.features.distributed.kvstore.api.JsonStore;
import org.opennms.netmgt.dao.api.NodeDao;
import org.opennms.netmgt.dao.api.ResourceDao;
import org.opennms.netmgt.filter.api.FilterDao;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.OnmsResource;
import org.opennms.netmgt.model.ResourceId;
import org.opennms.netmgt.model.resource.ResourceDTO;
import org.opennms.netmgt.model.resource.ResourceDTOCollection;
import org.opennms.web.rest.v1.OnmsRestService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component(value="resourceRestService")
@Path(value="resources")
@Tag(name="Resources", description="Resources API")
public class ResourceRestService
extends OnmsRestService {
    private static final Logger LOG = LoggerFactory.getLogger(ResourceRestService.class);
    @Autowired
    private NodeDao m_nodeDao;
    @Autowired
    private ResourceDao m_resourceDao;
    @Autowired
    private FilterDao m_filterDao;
    @Autowired
    private JsonStore m_jsonStore;
    private final Gson m_gson = new Gson();

    @GET
    @Produces(value={"application/xml", "application/json", "application/atom+xml"})
    @Transactional(readOnly=true)
    public ResourceDTOCollection getResources(@DefaultValue(value="1") @QueryParam(value="depth") int depth) {
        LinkedList resources = Lists.newLinkedList();
        for (OnmsResource resource : this.m_resourceDao.findTopLevelResources()) {
            resources.add(ResourceDTO.fromResource((OnmsResource)resource, (int)depth));
        }
        return new ResourceDTOCollection((Collection)resources);
    }

    @GET
    @Path(value="{resourceId}")
    @Produces(value={"application/xml", "application/json", "application/atom+xml"})
    @Transactional(readOnly=true)
    public ResourceDTO getResourceById(@PathParam(value="resourceId") String resourceId, @DefaultValue(value="-1") @QueryParam(value="depth") int depth) {
        OnmsResource resource = this.m_resourceDao.getResourceById(ResourceId.fromString((String)resourceId));
        if (resource == null) {
            throw ResourceRestService.getException(Response.Status.NOT_FOUND, "No resource with id '{}' found.", resourceId);
        }
        return ResourceDTO.fromResource((OnmsResource)resource, (int)depth);
    }

    @DELETE
    @Path(value="{resourceId}")
    @Transactional(readOnly=false)
    public void deleteResourceById(@PathParam(value="resourceId") String resourceId) {
        boolean found = this.m_resourceDao.deleteResourceById(ResourceId.fromString((String)resourceId));
        if (!found) {
            throw ResourceRestService.getException(Response.Status.NOT_FOUND, "No resource with id '{}' found.", resourceId);
        }
    }

    @GET
    @Path(value="fornode/{nodeCriteria}")
    @Produces(value={"application/xml", "application/json", "application/atom+xml"})
    @Transactional(readOnly=true)
    public ResourceDTO getResourceForNode(@PathParam(value="nodeCriteria") String nodeCriteria, @DefaultValue(value="-1") @QueryParam(value="depth") int depth) {
        OnmsNode node = this.m_nodeDao.get(nodeCriteria);
        if (node == null) {
            throw ResourceRestService.getException(Response.Status.NOT_FOUND, "No node found with criteria '{}'.", nodeCriteria);
        }
        OnmsResource resource = this.m_resourceDao.getResourceForNode(node);
        if (resource == null) {
            throw ResourceRestService.getException(Response.Status.NOT_FOUND, "No resource found for node with id {}.", "" + node.getId());
        }
        return ResourceDTO.fromResource((OnmsResource)resource, (int)depth);
    }

    @GET
    @Path(value="select")
    @Produces(value={"application/xml", "application/json", "application/atom+xml"})
    @Transactional(readOnly=true)
    public List<ResourceDTO> select(@DefaultValue(value="") @QueryParam(value="nodes") String nodes, @DefaultValue(value="") @QueryParam(value="filterRules") String filterRules, @DefaultValue(value="") @QueryParam(value="nodeSubresources") String nodeSubresources, @DefaultValue(value="") @QueryParam(value="stringProperties") String stringProperties) {
        Set allNodeIds = Stream.of(nodes.split(",")).map(String::trim).filter(xva$0 -> StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{xva$0})).collect(Collectors.toSet());
        Set ruleNodeIds = Stream.of(filterRules.split(",")).map(String::trim).filter(xva$0 -> StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{xva$0})).flatMap(s -> this.m_filterDao.getNodeMap(s).keySet().stream().map(String::valueOf)).collect(Collectors.toSet());
        allNodeIds.addAll(ruleNodeIds);
        List subresourceNames = Stream.of(nodeSubresources.split(",")).map(String::trim).filter(xva$0 -> StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{xva$0})).distinct().collect(Collectors.toList());
        Set stringPropertyNames = Stream.of(stringProperties.split(",")).map(String::trim).filter(xva$0 -> StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{xva$0})).collect(Collectors.toSet());
        Stream<ResourceDTO> resources = allNodeIds.stream().sorted().map(nodeId -> {
            if (nodeId.contains(":")) {
                OnmsNode node = this.m_nodeDao.get(nodeId);
                return node != null ? this.m_resourceDao.getResourceForNode(node) : null;
            }
            return this.m_resourceDao.getResourceById(ResourceId.get((String)"node", (String)nodeId));
        }).filter(r -> r != null).map(r -> ResourceDTO.fromResource((OnmsResource)r, (int)-1)).map(nodeResource -> {
            nodeResource.setRrdGraphAttributes(null);
            nodeResource.setStringPropertyAttributes(null);
            nodeResource.setExternalValueAttributes(null);
            if (nodeResource.getChildren() == null) {
                return nodeResource;
            }
            if (subresourceNames.isEmpty()) {
                for (ResourceDTO c : nodeResource.getChildren()) {
                    c.setChildren(null);
                    c.setRrdGraphAttributes(null);
                    c.setStringPropertyAttributes(null);
                    c.setExternalValueAttributes(null);
                }
            } else {
                Iterator subresourceIterator = nodeResource.getChildren().iterator();
                while (subresourceIterator.hasNext()) {
                    ResourceDTO subresource = (ResourceDTO)subresourceIterator.next();
                    if (subresourceNames.stream().anyMatch(name -> subresource.getId().endsWith("." + name))) {
                        subresource.setChildren(null);
                        subresource.setRrdGraphAttributes(null);
                        subresource.setExternalValueAttributes(null);
                        if (stringPropertyNames.isEmpty()) continue;
                        Iterator iter = subresource.getStringPropertyAttributes().keySet().iterator();
                        while (iter.hasNext()) {
                            String s = (String)iter.next();
                            if (stringPropertyNames.contains(s)) continue;
                            iter.remove();
                        }
                        continue;
                    }
                    subresourceIterator.remove();
                }
            }
            return nodeResource;
        });
        return resources.collect(Collectors.toList());
    }

    @POST
    @Path(value="generateId")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response saveResourcesWithId(String[] resources) {
        String resourcesInJson = this.m_gson.toJson((Object)resources);
        String key = UUID.nameUUIDFromBytes(resourcesInJson.getBytes()).toString();
        this.m_jsonStore.put(key, (Object)resourcesInJson, "resourceIds");
        String jsonKey = this.m_gson.toJson((Object)key);
        return Response.ok((Object)jsonKey).build();
    }
}

