/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.rest.v1;

import io.swagger.v3.oas.annotations.tags.Tag;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.ForbiddenException;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import org.apache.commons.io.input.ReversedLinesFileReader;
import org.springframework.stereotype.Component;

@Component
@Path(value="logs")
@Tag(name="Logs", description="Logs API")
public class LogRestService {
    public static final int DEFAULT_NUM_LINES = 5000;
    public static final int MAX_NUM_LINES = 10000;
    private static final String LOG_FILE_EXTENSION = ".log";
    private final java.nio.file.Path logFolder = Paths.get(System.getProperty("opennms.home"), "logs");

    @GET
    @Path(value="/")
    @Produces(value={"application/json"})
    public List<String> getLogFiles(@Context SecurityContext securityContext) {
        if (!securityContext.isUserInRole("ROLE_ADMIN")) {
            throw new ForbiddenException("ADMIN role is required for enumerating log files.");
        }
        try {
            return Files.find(this.logFolder, 1, (path, basicFileAttributes) -> path.getFileName().toString().endsWith(LOG_FILE_EXTENSION), FileVisitOption.FOLLOW_LINKS).map(p -> p.getFileName().toString()).sorted().collect(Collectors.toList());
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to enumerate log files in path: " + String.valueOf(this.logFolder), e);
        }
    }

    @GET
    @Path(value="/contents")
    public Response getFileContents(@QueryParam(value="f") String fileName, @QueryParam(value="n") Integer numLines, @QueryParam(value="reverse") @DefaultValue(value="true") boolean reverse, @Context SecurityContext securityContext) {
        if (!securityContext.isUserInRole("ROLE_ADMIN")) {
            throw new ForbiddenException("ADMIN role is required for reading log files.");
        }
        if (!fileName.endsWith(LOG_FILE_EXTENSION)) {
            throw new BadRequestException("Invalid log file extension access files outside of log folder! Filename given: " + fileName);
        }
        java.nio.file.Path logFilePath = this.logFolder.resolve(fileName);
        if (!Objects.equals(this.logFolder, logFilePath.getParent())) {
            throw new BadRequestException("Cannot access files outside of log folder! Filename given: " + fileName);
        }
        int N = 5000;
        if (numLines != null) {
            N = numLines;
        }
        N = Math.min(10000, Math.max(N, 1));
        return LogRestService.logFileContents(logFilePath, N, reverse);
    }

    public static Response logFileContents(java.nio.file.Path path, int numLastLinesToRead, boolean reverse) {
        if (!Files.exists(path, new LinkOption[0])) {
            return Response.noContent().build();
        }
        try {
            String mimeType = Files.probeContentType(path);
            LinkedList<String> lines = new LinkedList<String>();
            try (ReversedLinesFileReader reader = new ReversedLinesFileReader(path.toFile(), StandardCharsets.UTF_8);){
                for (int k = 0; k < numLastLinesToRead; ++k) {
                    String line = reader.readLine();
                    if (line == null) {
                        break;
                    }
                    lines.add(line);
                }
            }
            StringBuilder sb = new StringBuilder();
            if (!reverse) {
                Collections.reverse(lines);
            }
            for (String line : lines) {
                sb.append(line);
                sb.append("\n");
            }
            return Response.ok((Object)sb.toString()).type(mimeType).header("Content-Disposition", (Object)path.getFileName().toString()).header("Last-Modified", (Object)new Date(Files.getLastModifiedTime(path, new LinkOption[0]).toMillis())).build();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

