/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.rest.v1;

import io.swagger.v3.oas.annotations.tags.Tag;
import java.net.URI;
import java.util.ArrayList;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.container.ResourceContext;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.opennms.netmgt.dao.api.CategoryDao;
import org.opennms.netmgt.model.OnmsCategory;
import org.opennms.netmgt.model.OnmsCategoryCollection;
import org.opennms.web.rest.support.MultivaluedMapImpl;
import org.opennms.web.rest.v1.GroupRestService;
import org.opennms.web.rest.v1.NodeRestService;
import org.opennms.web.rest.v1.OnmsRestService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.PropertyAccessorFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component(value="categoryRestService")
@Path(value="categories")
@Tag(name="Categories", description="Categories API")
@Transactional
public class CategoryRestService
extends OnmsRestService {
    private static final Logger LOG = LoggerFactory.getLogger(CategoryRestService.class);
    @Autowired
    private CategoryDao m_categoryDao;

    @GET
    @Produces(value={"application/xml", "application/json"})
    @Path(value="/nodes/{nodeCriteria}")
    public OnmsCategoryCollection getCategoriesForNode(@Context ResourceContext context, @PathParam(value="nodeCriteria") String nodeCriteria) {
        return ((NodeRestService)context.getResource(NodeRestService.class)).getCategoriesForNode(nodeCriteria);
    }

    @GET
    @Produces(value={"application/xml", "application/json"})
    @Path(value="{categoryName}/nodes/{nodeCriteria}")
    public OnmsCategory getCategoryForNode(@Context ResourceContext context, @PathParam(value="nodeCriteria") String nodeCriteria, @PathParam(value="categoryName") String categoryName) {
        return ((NodeRestService)context.getResource(NodeRestService.class)).getCategoryForNode(nodeCriteria, categoryName);
    }

    @PUT
    @Consumes(value={"application/xml"})
    @Path(value="{categoryName}/nodes/{nodeCriteria}/")
    public Response addCategoryToNode(@Context ResourceContext context, @Context UriInfo uriInfo, @PathParam(value="nodeCriteria") String nodeCriteria, @PathParam(value="categoryName") String categoryName) {
        return ((NodeRestService)context.getResource(NodeRestService.class)).addCategoryToNode(uriInfo, nodeCriteria, categoryName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PUT
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Path(value="/{categoryName}")
    public Response updateCategory(@PathParam(value="categoryName") String categoryName, MultivaluedMapImpl params) {
        this.writeLock();
        try {
            Response response;
            OnmsCategory category = this.m_categoryDao.findByName(categoryName);
            if (category == null) {
                throw CategoryRestService.getException(Response.Status.BAD_REQUEST, "Category with name '{}' was not found.", categoryName);
            }
            LOG.debug("updateCategory: updating category {}", (Object)category);
            BeanWrapper wrapper = PropertyAccessorFactory.forBeanPropertyAccess((Object)category);
            boolean modified = false;
            for (String key : params.keySet()) {
                if (!wrapper.isWritableProperty(key)) continue;
                String stringValue = (String)params.getFirst(key);
                Object value = wrapper.convertIfNecessary((Object)stringValue, wrapper.getPropertyType(key));
                wrapper.setPropertyValue(key, value);
                modified = true;
            }
            LOG.debug("updateCategory: category {} updated", (Object)category);
            if (modified) {
                this.m_categoryDao.saveOrUpdate((Object)category);
                response = Response.noContent().build();
                return response;
            }
            response = Response.notModified().build();
            return response;
        }
        finally {
            this.writeUnlock();
        }
    }

    @DELETE
    @Path(value="/{categoryName}/nodes/{nodeCriteria}/")
    public Response removeCategoryFromNode(@Context ResourceContext context, @PathParam(value="nodeCriteria") String nodeCriteria, @PathParam(value="categoryName") String categoryName) {
        return ((NodeRestService)context.getResource(NodeRestService.class)).removeCategoryFromNode(nodeCriteria, categoryName);
    }

    @GET
    @Path(value="/{categoryName}")
    @Produces(value={"application/xml", "application/json"})
    public OnmsCategory getCategory(@PathParam(value="categoryName") String categoryName) {
        OnmsCategory category = this.m_categoryDao.findByName(categoryName);
        if (category == null) {
            throw CategoryRestService.getException(Response.Status.NOT_FOUND, "Category with name '{}' was not found.", categoryName);
        }
        return category;
    }

    @POST
    @Path(value="/")
    public Response createCategory(@Context UriInfo uriInfo, OnmsCategory category) {
        boolean exists;
        if (category == null) {
            throw CategoryRestService.getException(Response.Status.BAD_REQUEST, "Category must not be null.", new String[0]);
        }
        boolean bl = exists = this.m_categoryDao.findByName(category.getName()) != null;
        if (!exists) {
            this.m_categoryDao.save((Object)category);
            return Response.created((URI)CategoryRestService.getRedirectUri(uriInfo, category.getName())).build();
        }
        throw CategoryRestService.getException(Response.Status.BAD_REQUEST, "A category with name '{}' already exists.", category.getName());
    }

    @GET
    @Path(value="/")
    @Produces(value={"application/xml", "application/json"})
    public OnmsCategoryCollection listCategories() {
        return new OnmsCategoryCollection(new ArrayList(this.m_categoryDao.findAll()));
    }

    @DELETE
    @Path(value="/{categoryName}")
    public Response deleteCategory(@PathParam(value="categoryName") String categoryName) {
        OnmsCategory category = this.m_categoryDao.findByName(categoryName);
        if (category != null) {
            this.m_categoryDao.delete((Object)category);
            return Response.noContent().build();
        }
        throw CategoryRestService.getException(Response.Status.BAD_REQUEST, "A category with name '{}' does not exist.", categoryName);
    }

    @PUT
    @Path(value="/{categoryName}/groups/{groupName}")
    public Response addCategoryToGroup(@Context ResourceContext context, @PathParam(value="groupName") String groupName, @PathParam(value="categoryName") String categoryName) {
        return ((GroupRestService)context.getResource(GroupRestService.class)).addCategory(groupName, categoryName);
    }

    @DELETE
    @Path(value="/{categoryName}/groups/{groupName}")
    public Response removeCategoryFromGroup(@Context ResourceContext context, @PathParam(value="groupName") String groupName, @PathParam(value="categoryName") String categoryName) {
        return ((GroupRestService)context.getResource(GroupRestService.class)).removeCategory(groupName, categoryName);
    }

    @GET
    @Path(value="/groups/{groupName}")
    @Produces(value={"application/xml", "application/json"})
    public OnmsCategoryCollection listCategoriesForGroup(@Context ResourceContext context, @PathParam(value="groupName") String groupName) {
        return ((GroupRestService)context.getResource(GroupRestService.class)).listCategories(groupName);
    }
}

