/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.rest.support.menu;

import com.fasterxml.jackson.databind.DatabindException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.time.LocalDate;
import java.util.List;
import org.opennms.core.resource.Vault;
import org.opennms.web.rest.support.menu.MenuRequestContext;
import org.opennms.web.rest.support.menu.model.MainMenu;
import org.opennms.web.rest.support.menu.model.MenuEntry;

public class MenuProvider {
    private final String ROLE_BASED_NAV_BAR_ENTRY_CLASS = "org.opennms.web.navigate.RoleBasedNavBarEntry";
    private final String ADMIN_ROLE_ICON = "fa-cogs";
    public static final String ZENITH_CONNECT_ENABLED_KEY = "opennms.zenithConnect.enabled";
    public static final String ZENITH_CONNECT_BASE_URL_KEY = "opennms.zenithConnect.zenithBaseUrl";
    public static final String ZENITH_CONNECT_RELATIVE_URL_KEY = "opennms.zenithConnect.zenithRelativeUrl";
    private static final ImmutableSet<String> ADMIN_ROLES = ImmutableSet.of((Object)"ROLE_ADMIN", (Object)"ROLE_FILESYSTEM_EDITOR");
    private String menuTemplateFilePath;
    private MenuRequestContext menuRequestContext;

    public MenuProvider(String menuTemplateFilePath) {
        this.menuTemplateFilePath = menuTemplateFilePath;
    }

    public void setMenuRequestContext(MenuRequestContext context) {
        this.menuRequestContext = context;
    }

    public String getMenuTemplateFilePath() {
        return this.menuTemplateFilePath;
    }

    public void setMenuTemplateFilePath(String path) {
        this.menuTemplateFilePath = path;
    }

    public MainMenu getMainMenu() throws Exception, IOException {
        this.ensureContext();
        MainMenu mainMenu = this.generateMenuFromTemplate();
        return mainMenu;
    }

    public MainMenu generateMenuFromTemplate() throws Exception, IOException {
        return this.generateMenuFromTemplate(null);
    }

    public MainMenu generateMenuFromTemplate(String menuTemplateFile) throws Exception, IOException {
        String templatePath = menuTemplateFile != null ? menuTemplateFile : this.menuTemplateFilePath;
        MainMenu mainMenu = this.parseMenuTemplate(templatePath);
        if (mainMenu == null) {
            return null;
        }
        mainMenu.baseHref = this.menuRequestContext.calculateUrlBase();
        mainMenu.homeUrl = mainMenu.baseHref + "index.jsp";
        mainMenu.formattedDateTime = this.menuRequestContext.getFormattedDateTime();
        mainMenu.formattedDate = this.menuRequestContext.getFormattedDate();
        mainMenu.formattedTime = this.menuRequestContext.getFormattedTime();
        mainMenu.username = this.menuRequestContext.getRemoteUser();
        mainMenu.baseNodeUrl = "element/node.jsp?node=";
        mainMenu.zenithConnectEnabled = Strings.nullToEmpty((String)this.menuRequestContext.getSystemProperty(ZENITH_CONNECT_ENABLED_KEY, "false")).equals("true");
        mainMenu.zenithConnectBaseUrl = this.menuRequestContext.getSystemProperty(ZENITH_CONNECT_BASE_URL_KEY, "");
        mainMenu.zenithConnectRelativeUrl = this.menuRequestContext.getSystemProperty(ZENITH_CONNECT_RELATIVE_URL_KEY, "");
        mainMenu.noticeStatus = this.menuRequestContext.getNoticeStatus();
        mainMenu.copyrightDates = String.format("2002-%d", LocalDate.now().getYear());
        mainMenu.version = Vault.getProperty((String)"version.display");
        List<MenuEntry> filteredTopMenuEntries = this.filterMenuEntriesByRole(mainMenu.menus);
        filteredTopMenuEntries = this.filterMenuEntriesBySystemProperties(filteredTopMenuEntries);
        mainMenu.menus.clear();
        mainMenu.menus.addAll(filteredTopMenuEntries);
        mainMenu.helpMenu.items = this.filterMenuEntriesByRole(mainMenu.helpMenu.items);
        mainMenu.selfServiceMenu.name = this.menuRequestContext.getRemoteUser();
        MenuEntry userMenu = mainMenu.userNotificationMenu.items.stream().filter(i -> i.id != null && i.id.equals("userNotificationUser")).findFirst().orElse(null);
        if (userMenu != null && userMenu.url != null) {
            userMenu.url = userMenu.url.replace("$USER", this.menuRequestContext.getRemoteUser());
        }
        if (!this.evaluateRoleBasedMenuEntry(mainMenu.provisionMenu)) {
            mainMenu.provisionMenu = null;
        }
        if (!this.evaluateRoleBasedMenuEntry(mainMenu.configurationMenu)) {
            mainMenu.configurationMenu = null;
        }
        return mainMenu;
    }

    public MainMenu parseMenuTemplate() {
        return this.parseMenuTemplate(null);
    }

    public MainMenu parseMenuTemplate(String menuTemplateFile) {
        String MENU_TEMPLATE_FILE = "./menu-template.json";
        ObjectMapper objectMapper = new ObjectMapper();
        MainMenu template = null;
        String path = menuTemplateFile != null ? menuTemplateFile : "./menu-template.json";
        try (FileInputStream fis = new FileInputStream(path);){
            template = (MainMenu)objectMapper.readValue((InputStream)fis, MainMenu.class);
        }
        catch (FileNotFoundException fnfe) {
            System.out.println("ERROR: FileNotFoundException: " + fnfe.getMessage());
            return null;
        }
        catch (DatabindException dbex) {
            System.out.println("ERROR: DatabindException: " + dbex.getMessage());
            return null;
        }
        catch (Exception e) {
            System.out.println("ERROR: Exception: " + e.getMessage());
            return null;
        }
        return template;
    }

    private void ensureContext() throws Exception {
        if (this.menuRequestContext == null) {
            throw new Exception("Must set MenuRequestContext when using a MenuProvider.");
        }
    }

    private List<MenuEntry> filterMenuEntriesByRole(List<MenuEntry> entries) {
        List<MenuEntry> filteredEntries = entries.stream().filter(this::evaluateRoleBasedMenuEntry).toList();
        for (MenuEntry filteredEntry : filteredEntries) {
            if (filteredEntry.items == null || filteredEntry.items.isEmpty()) continue;
            filteredEntry.items = this.filterMenuEntriesByRole(filteredEntry.items);
        }
        return filteredEntries;
    }

    private List<MenuEntry> filterMenuEntriesBySystemProperties(List<MenuEntry> entries) {
        List<MenuEntry> filteredEntries = entries.stream().filter(this::evaluateRequiredSystemProperties).toList();
        for (MenuEntry filteredEntry : filteredEntries) {
            if (filteredEntry.items == null || filteredEntry.items.isEmpty()) continue;
            filteredEntry.items = this.filterMenuEntriesBySystemProperties(filteredEntry.items);
        }
        return filteredEntries;
    }

    private boolean evaluateRoleBasedMenuEntry(MenuEntry menuEntry) {
        if (menuEntry.roles != null && !menuEntry.roles.isEmpty()) {
            return this.menuRequestContext.isUserInAnyRole(menuEntry.roles);
        }
        return true;
    }

    private boolean evaluateRequiredSystemProperties(MenuEntry menuEntry) {
        if (menuEntry.requiredSystemProperties != null && !menuEntry.requiredSystemProperties.isEmpty()) {
            return menuEntry.requiredSystemProperties.stream().allMatch(p -> this.evaluateSystemPropertyMenuEntry(p.name, p.value));
        }
        return true;
    }

    private boolean evaluateSystemPropertyMenuEntry(String systemProperty, String systemPropertyValue) {
        if (!Strings.isNullOrEmpty((String)systemProperty) && !Strings.isNullOrEmpty((String)systemPropertyValue)) {
            String value = this.menuRequestContext.getSystemProperty(systemProperty, "");
            return !Strings.isNullOrEmpty((String)value) && value.equals(systemPropertyValue);
        }
        return true;
    }
}

